#!/usr/perl5/bin/perl

use strict;
use warnings;

use Data::Dumper;

use Sun::Solaris::Kstat;

my $kstat = Sun::Solaris::Kstat->new();

for (my $i = 0; 1; $i++)
{
	last unless (exists ($kstat->{'cpu_stat'}{$i}));

	my $s = $kstat->{'cpu_stat'}{$i}{"cpu_stat$i"};

	print STDOUT "suncpu$i=", join (',', @$s{qw(user kernel wait idle)}), "\n";
	print STDOUT "page=", $s->{'pgin'}, ',', $s->{'pgout'}, "\n";
	print STDOUT "ctxt=", $s->{'pswitch'}, "\n";
	print STDOUT "intr=", $s->{'intr'}, "\n";
}

exit (0);
