#!/usr/bin/perl

use strict;
use warnings;

use DBI ();

our $ConfigFile = '/etc/capman/mysql.conf';
our $Username = 'capman';
our $Password = '';
our $Hostname = 'localhost';
our $Database = 'test';

our $dsn;
our $dbh;

get_params ();

# DBI:mysql:cgidata:localhost
$dsn = "DBI:mysql:database=test;host=localhost";
$dbh = DBI->connect ($dsn, $Username, $Password, {RaiseError => 1});

my $sth = $dbh->prepare ('SHOW STATUS');

$sth->execute ();
while (my ($key, $val) = $sth->fetchrow_array ())
{
	next if ($key =~ m/^(com|handler)_/i);
	print STDOUT 'mysql_' . lc ($key) . '=' . $val . "\n";
}

$sth->finish ();
$dbh->disconnect ();

exit (0);

sub get_params
{
	my $fh;

	open ($fh, "< $ConfigFile") or die ("open ($ConfigFile): $!");
	while (<$fh>)
	{
		chomp;
		if (m/^\s*(\w+):\s*(\S+)/)
		{
			my $key = lc ($1);
			my $val = $2;

			if ($key =~ m/^user(name)?$/)
			{
				$Username = $val;
			}
			elsif ($key =~ m/^pass(word)?$/)
			{
				$Password = $val;
			}
			elsif ($key =~ m/^host(name)?$/)
			{
				$Hostname = $val;
			}
			elsif ($key eq 'database')
			{
				$Database = $val;
			}
			else
			{
				print STDERR "Unknown config option in $ConfigFile: $key\n";
			}
		}
	}
	close ($fh);
}
