#!/usr/bin/perl

# Copyright (C) 2002-2005, Eleven GmbH, Berlin 
#
# This is an EXAMPLE how to create a chroot environment for eXpurgate
# on _Linux_.
# Use this on your OWN RISK, eleven gives no warranty and support on this.

# When the script succeded you can start eXpurgate in a chroot environment.
# For that you have to edit the etc/expurgate.xml and set the installpath
# to '/'.
# An example to start eXpurgate in a chroot environment is:
# > chroot /usr/local/eleven bin/expurgate -f /etc/expurgate.xml 
#
# You also can tell eXpurgate to switch to the unpriviliged user 'eleven' after
# starting with root permissions. To do that add the options
# '--uid=eleven --gid=eleven' to the commandline.

# Delete the following two lines if you have red and aggreed to the banner above.
print "Please read the disclaimer of this script to continue.\n";
exit 1;

###############################################################################

my @directoriesToCreate = ( "lib", "dev" );

###############################################################################

my @addOnLibs = ( "libnss_dns", "libnss_files", "libresolv", "libpthread", "libgcc_s" );

###############################################################################

my %createDevices = (
    "dev/null"   => ["c",1,3],
    "dev/random" => ["c",1,8],
);

###############################################################################

my %createFiles = ( 
    "etc/passwd" => [ "root.root", "0444", 
"root:x:0:0:root:/root:/bin/false
bin:x:1:1:bin:/bin:/bin/false
daemon:x:2:2:Daemon:/sbin:/bin/false
eleven:x:111:111:eleven account:/:/bin/false" ],

    "etc/shadow" => [ "root.root", "0400", 
"root:*:0:10000::::
bin:*:8902:0:10000::::
daemon:*:8902:0:10000::::
eleven:*:8902:0:10000::::" ],

    "etc/group" => [ "root.root", "0444", 
"root:x:0:root
bin:x:1:root,bin,daemon
daemon:x:2:
eleven:x:111:" ],

    "etc/nsswitch.conf" => [ "root.root", "0444", 
"passwd: files
shadow: files
group: files
hosts: files dns" ],

);

###############################################################################

my %copyFiles = (
    "/etc/hosts"       => "etc/",
    "/etc/localtime"   => "etc/",
    "/etc/resolv.conf" => "etc/",
    "/bin/false"       => "bin/",
);

###############################################################################
###############################################################################
###############################################################################
###############################################################################
###############################################################################

if ( ! -e "bin/expurgate" )
{
    print "ERROR: Can not open 'bin/expurgate', change directory to /usr/local/eleven ?!\n";
    exit 1;
}

###############################################################################
# check requirements
###############################################################################

my @missing  = (); 

my $out;
my $line;

# check against which libs expurgate is linked and copy them
$out = `ldd bin/expurgate`;

foreach $line ( split(/\r?\n/, $out) )
{
    if ( $line !~ /^\s+(\S+)\s+\=\>\s+(\S*)\s(\S+)/ )
    {
        print "ERROR: Can not parse ldd output: '$line'\n";
        exit 1;
    }

    next if $line =~ /.*linux.gate.*/; 
    
    my $file = $2;
    my $subDir = "";

    if ( $file eq "" )
    {
	push ( @missing, $file ); 
        next;
    }

    if ( $file =~ /^\/lib\/(.+)\/[^\/]+$/ )
    {
        $subDir = "$1/";
        push ( @directoriesToCreate, "lib/$subDir" );
    }

    $copyFiles{ $file } = "lib/$subDir";
}
															


# copy add on libraries
foreach $line ( @addOnLibs )
{
    my $file;
    my $found = 0;
    
    foreach $file ( </lib/${line}*> )
    {
	
        if ( $file !~ /^\/lib\/${line}(\.so\..+)|(.+\.so)$/ )
        {
           print "skip for '$line': $file\n";
            next;
        }

	$copyFiles{ $file } = "lib";
        
        $found = 1;
    }

    if ( ! $found )
    {
	push ( @missing, $line ."\n" );
    }
}


foreach $line ( keys( %copyFiles ) )
{
	push ( @missing, $line . "\n" ) if (! -e $line );
}

if ( scalar(@missing) != 0 )
{
    print "The following files are missing. Please install them and run this script again:\n";
    print "@missing\n";
    exit 1;
}


###############################################################################

if ( ! &createDirectories( @directoriesToCreate ) )
{
    exit 1;
}

###############################################################################


foreach $line ( keys( %createDevices ) )
{
    next if ( -e $line );

    my $exe = "mknod $line " . 
                          $createDevices{ $line }->[0] .
                    " " . $createDevices{ $line }->[1] .
                    " " . $createDevices{ $line }->[2];
                    
    if ( ! &doExec( $exe ) )
    {
        print "ERROR: Can not create device '$line': $!\n";
        exit 1;
    }
}

###############################################################################

foreach $line ( keys( %createFiles ) )
{
    print "> create $line\n";
    if ( ! open( FILE, ">$line" ) )
    {
        print "ERROR: Can not create file '$line': $!\n";
        exit 1;
    }
    
    print FILE $createFiles{ $line }->[2];
    
    close FILE;
    
    if ( ! &doExec( "chown " . $createFiles{ $line }->[0] . " $line" ) )
    {
        print "ERROR: Can not change owner to '" . 
              $createFiles{ $line }->[2] . 
              "' for file '$line': $!\n";
        exit 1;
    }
    
    if ( ! &doExec( "chmod " . $createFiles{ $line }->[1] . " $line" ) )
    {
        print "ERROR: Can not change permissions to '" . 
              $createFiles{ $line }->[1] . 
              "' for file '$line': $!\n";
        exit 1;
    }
}

###############################################################################

foreach $line ( keys( %copyFiles ) )
{
    # copy files
    
    if ( ! -e $line ) 
    { 
    	@args=( "touch", "$line" );
    	system( @args );
    }
    
    next if ( -l $file );

    if ( ! &doExec( "cp $line " . $copyFiles{ $line } ) )
    {
        print "ERROR: Can not copy file '$file' to '".$copyFiles{ $line }."': $!\n";
        exit 1;
    }
}

print "ready.\n";

###############################################################################

exit 0;

###############################################################################
###############################################################################

sub createDirectories
{
    my ( @dirs ) = @_;

    foreach ( @dirs )
    {
        if ( ! -d "$_" )
        {
            print "> mkdir $_\n";
            
            if ( ! mkdir( $_ ) )
            {
                print "ERROR: Can not create directory '$_': $!\n";
                return 0;
            }
        }
    }
    return 1;
}

###############################################################################

sub doExec
{
    my ( $exeStr ) = @_;
    
    print "> $exeStr\n";
    
    system( $exeStr );
    
    if ( $? )
    {
        return 0;
    }
    
    return 1;
}
