# --
# QueueFunctions.t - Test Functions in Queue Object
# Copyright (C) Stelios Gikas <stelios.gikas@noris.net> 
# --

use Kernel::System::Queue;

$Self->{QueueObject} = Kernel::System::Queue->new( %{$Self} );

sub _compare_arrays {
    my ($first, $second) = @_;
    no warnings;  # silence spurious -w undef complaints
    return 0 unless @$first == @$second;
    for (my $i = 0; $i < @$first; $i++) {
        return 0 if $first->[$i] ne $second->[$i];
    }
    return 1;
}

my ( $QueueName, @expected, @result );

# ------------
$QueueName = 'one::two::three';
@expected = qw( one::two::three::* one::two::three:: one::two::* one::two:: one::* one:: * );
@result = $Self->{QueueObject}->_GetQueueSearchKeys($QueueName);
$Self->True(
    _compare_arrays(\@result, \@expected),
    'one::two::three - Without itself',
);

unshift @expected, $QueueName;
@result = $Self->{QueueObject}->_GetQueueSearchKeys($QueueName, 1);
$Self->True(
    _compare_arrays(\@result, \@expected),
    'one::two::three - With itself',
);

# ------------
$QueueName = 'one::two';
@expected = qw( one::two::* one::two:: one::* one:: * );
@result = $Self->{QueueObject}->_GetQueueSearchKeys($QueueName);
$Self->True(
    _compare_arrays(\@result, \@expected),
    'one::two - Without itself',
);

unshift @expected, $QueueName;
@result = $Self->{QueueObject}->_GetQueueSearchKeys($QueueName, 1);
$Self->True(
    _compare_arrays(\@result, \@expected),
    'one::two - With itself',
);

# ------------
$QueueName = 'one';
@expected = qw( one::* one:: * );
@result = $Self->{QueueObject}->_GetQueueSearchKeys($QueueName);
$Self->True(
    _compare_arrays(\@result, \@expected),
    'one - Without itself',
);

unshift @expected, $QueueName;
@result = $Self->{QueueObject}->_GetQueueSearchKeys($QueueName, 1);
$Self->True(
    _compare_arrays(\@result, \@expected),
    'one - With itself',
);

1;
