# --
# Noris_Queue.t - Noris Queue module testscript
# Copyright (C) 2009 noris network AG, http://www.noris.net/
# --
# $Id$
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

use utf8;
use Kernel::System::Ticket;
use Kernel::System::Queue;

$Self->{TicketObject} = Kernel::System::Ticket->new( %{$Self} );
$Self->{QueueObject}  = Kernel::System::Queue->new( %{$Self} );

my %Types = $Self->{TicketObject}->TicketTypeList(
    QueueID => 1,
    UserID  => 1,
);

# AgentTicketClose
# AgentTicketCompose
# AgentTicketComposeInternal
# AgentTicketEmail
# AgentTicketNote
# AgentTicketPhone
my $DefaultFields = {
    'default'            => { Text => '1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'BF'                 => { Text => '1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'CCM'                => { Text => '1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'CCM::Followup'      => { Text => '1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'Change'             => { Text => '1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'Incident'           => { Text => '1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1', Time => '1 1 1 0 1 0' },
    'Incident::Followup' => { Text => '1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'Problem'            => { Text => '1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'Projekt'            => { Text => '1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'Service'            => { Text => '1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'Sonstiges'          => { Text => '1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
};

my $InfoFieldsOnly = {
    'default'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'BF'                 => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'CCM'                => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'CCM::Followup'      => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'Change'             => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'Incident'           => { Text => '1 0 1 0 0 0 0 0 0 0 0 0 0 0 1 1', Time => '1 1 1 0 1 0' },
    'Incident::Followup' => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'Problem'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'Projekt'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'Service'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
    'Sonstiges'          => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 0 0 0 0 0' },
};
my $InfoFieldsNoTime = {
    'default'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'BF'                 => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'CCM'                => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'CCM::Followup'      => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'Change'             => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'Incident'           => { Text => '1 0 1 0 0 0 0 0 0 0 0 0 0 0 1 1', Time => '0 1 1 0 1 0' },
    'Incident::Followup' => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'Problem'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'Projekt'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'Service'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'Sonstiges'          => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
};

my $SDInfoFieldsOnly = {
    'default'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 1 1 1 0 0' },
    'BF'                 => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 1 1 1 0 0' },
    'CCM'                => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 1 1 1 0 0' },
    'CCM::Followup'      => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 1 1 1 0 0' },
    'Change'             => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 1 1 1 0 0' },
    'Incident'           => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 1 1 1 0 0' },
    'Incident::Followup' => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 1 1 1 0 0' },
    'Problem'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 1 1 1 0 0' },
    'Projekt'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 1 1 1 0 0' },
    'Service'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 1 1 1 0 0' },
    'Sonstiges'          => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '1 1 1 1 0 0' },
};
my $SDInfoFieldsOnly0 = {
    'default'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'BF'                 => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'CCM'                => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'CCM::Followup'      => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'Change'             => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'Incident'           => { Text => '1 0 1 0 0 0 0 0 0 0 0 0 0 0 1 1', Time => '0 1 1 0 1 0' },
    'Incident::Followup' => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'Problem'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'Projekt'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'Service'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
    'Sonstiges'          => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 0 0 0 0 0' },
};
my $SDInfoFieldsOnly1 = {
    'default'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 1 1 1 0 0' },
    'BF'                 => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 1 1 1 0 0' },
    'CCM'                => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 1 1 1 0 0' },
    'CCM::Followup'      => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 1 1 1 0 0' },
    'Change'             => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 1 1 1 0 0' },
    'Incident'           => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 1 1 1 0 0' },
    'Incident::Followup' => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 1 1 1 0 0' },
    'Problem'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 1 1 1 0 0' },
    'Projekt'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 1 1 1 0 0' },
    'Service'            => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 1 1 1 0 0' },
    'Sonstiges'          => { Text => '1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0', Time => '0 1 1 1 0 0' },
};

my $SD_Quelle_Fields = {
    'default'            => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 1 1 1 0 0' },
    'BF'                 => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 1 1 1 0 0' },
    'CCM'                => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 1 1 1 0 0' },
    'CCM::Followup'      => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 1 1 1 0 0' },
    'Change'             => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 1 1 1 0 0' },
    'Incident'           => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 1 1 1 0 0' },
    'Incident::Followup' => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 1 1 1 0 0' },
    'Problem'            => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 1 1 1 0 0' },
    'Projekt'            => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 1 1 1 0 0' },
    'Service'            => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 1 1 1 0 0' },
    'Sonstiges'          => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 1 1 1 0 0' },
};


# Check FreeText and FreeTime Fields depending on the Queue
my $FreeFields = {
    AgentTicketClose => {
        'domain'                => $InfoFieldsNoTime,
        'ew'                    => $InfoFieldsNoTime,
        'ew::bibliothek'        => $InfoFieldsNoTime,
        'ew::collectd'          => $InfoFieldsNoTime,
        'ew::kunde'             => $InfoFieldsNoTime,
        'ew::kundebunt'         => $InfoFieldsNoTime,
        'ew::nagios'            => $InfoFieldsNoTime,
        'ew::otrs'              => $InfoFieldsNoTime,
        'ew::pop-db'            => $InfoFieldsNoTime,
        'ew::rt'                => $InfoFieldsNoTime,
        'Junk'                  => $InfoFieldsNoTime,
        'Misc'                  => $InfoFieldsNoTime,
        'Postmaster'            => $InfoFieldsNoTime,
        'Raw'                   => $InfoFieldsNoTime,
        'sd'                    => $InfoFieldsNoTime,
        'sd::fcc'               => $SDInfoFieldsOnly0,
        'sd::nfon::incident'    => $SDInfoFieldsOnly0,
        'sd::quelle::change'    => $SDInfoFieldsOnly1,
        'sd::quelle::clients'   => $SDInfoFieldsOnly1,
        'sd::quelle::incident'  => $SDInfoFieldsOnly1,
        'sd::quelle::info'      => $SDInfoFieldsOnly1,
        'sd::quelle::knowledge' => $SDInfoFieldsOnly1,
        'sd::quelle::problem'   => $SDInfoFieldsOnly1,
        'sd::quelle::sr'        => $SDInfoFieldsOnly1,
        'technik'               => $InfoFieldsNoTime,
        'test'                  => $InfoFieldsNoTime,
    },
    AgentTicketCompose => {
        'domain'                => $InfoFieldsOnly,
        'ew'                    => $InfoFieldsOnly,
        'ew::bibliothek'        => $InfoFieldsOnly,
        'ew::collectd'          => $InfoFieldsOnly,
        'ew::kunde'             => $InfoFieldsOnly,
        'ew::kundebunt'         => $InfoFieldsOnly,
        'ew::nagios'            => $InfoFieldsOnly,
        'ew::otrs'              => $InfoFieldsOnly,
        'ew::pop-db'            => $InfoFieldsOnly,
        'ew::rt'                => $InfoFieldsOnly,
        'Junk'                  => $InfoFieldsOnly,
        'Misc'                  => $InfoFieldsOnly,
        'Postmaster'            => $InfoFieldsOnly,
        'Raw'                   => $InfoFieldsOnly,
        'sd'                    => $InfoFieldsOnly,
        'sd::fcc'               => $InfoFieldsOnly,
        'sd::nfon::incident'    => $InfoFieldsOnly,
        'sd::quelle::change'    => $SDInfoFieldsOnly,
        'sd::quelle::clients'   => $SDInfoFieldsOnly,
        'sd::quelle::incident'  => $SDInfoFieldsOnly,
        'sd::quelle::info'      => $SDInfoFieldsOnly,
        'sd::quelle::knowledge' => $SDInfoFieldsOnly,
        'sd::quelle::problem'   => $SDInfoFieldsOnly,
        'sd::quelle::sr'        => $SDInfoFieldsOnly,
        'technik'               => $InfoFieldsOnly,
#        'test'                  => $InfoFieldsOnly,
    },
    AgentTicketComposeInternal => {
        'domain'                => $InfoFieldsOnly,
        'ew'                    => $InfoFieldsOnly,
        'ew::bibliothek'        => $InfoFieldsOnly,
        'ew::collectd'          => $InfoFieldsOnly,
        'ew::kunde'             => $InfoFieldsOnly,
        'ew::kundebunt'         => $InfoFieldsOnly,
        'ew::nagios'            => $InfoFieldsOnly,
        'ew::otrs'              => $InfoFieldsOnly,
        'ew::pop-db'            => $InfoFieldsOnly,
        'ew::rt'                => $InfoFieldsOnly,
        'Junk'                  => $InfoFieldsOnly,
        'Misc'                  => $InfoFieldsOnly,
        'Postmaster'            => $InfoFieldsOnly,
        'Raw'                   => $InfoFieldsOnly,
        'sd'                    => $InfoFieldsOnly,
        'sd::fcc'               => $InfoFieldsOnly,
        'sd::nfon::incident'    => $InfoFieldsOnly,
        'sd::quelle::change'    => $SDInfoFieldsOnly,
        'sd::quelle::clients'   => $SDInfoFieldsOnly,
        'sd::quelle::incident'  => $SDInfoFieldsOnly,
        'sd::quelle::info'      => $SDInfoFieldsOnly,
        'sd::quelle::knowledge' => $SDInfoFieldsOnly,
        'sd::quelle::problem'   => $SDInfoFieldsOnly,
        'sd::quelle::sr'        => $SDInfoFieldsOnly,
        'technik'               => $InfoFieldsOnly,
        'test'                  => $InfoFieldsOnly,
    },
    AgentTicketEmail => {
        'domain'                => $DefaultFields,
        'ew'                    => $DefaultFields,
        'ew::bibliothek'        => $DefaultFields,
        'ew::collectd'          => $DefaultFields,
        'ew::kunde'             => $DefaultFields,
        'ew::kundebunt'         => $DefaultFields,
        'ew::nagios'            => $DefaultFields,
        'ew::otrs'              => $DefaultFields,
        'ew::pop-db'            => $DefaultFields,
        'ew::rt'                => $DefaultFields,
        'Junk'                  => $DefaultFields,
        'Misc'                  => $DefaultFields,
        'Postmaster'            => $DefaultFields,
        'Raw'                   => $DefaultFields,
        'sd'                    => $DefaultFields,
        'sd::fcc'               => $DefaultFields,
        'sd::nfon::incident'    => $DefaultFields,
        'sd::quelle::change'    => $SD_Quelle_Fields,
        'sd::quelle::clients'   => $SD_Quelle_Fields,
        'sd::quelle::incident'  => {
            'default'            => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'BF'                 => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'CCM'                => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'CCM::Followup'      => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Change'             => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Incident'           => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Incident::Followup' => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Problem'            => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Projekt'            => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Service'            => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Sonstiges'          => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
        },
        'sd::quelle::info'      => $SD_Quelle_Fields,
        'sd::quelle::knowledge' => $SD_Quelle_Fields,
        'sd::quelle::problem'   => $SD_Quelle_Fields,
        'sd::quelle::sr'        => $SD_Quelle_Fields,
        'technik'               => $DefaultFields,
        'test'                  => {
            'default'            => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'BF'                 => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'CCM'                => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'CCM::Followup'      => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'Change'             => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'Incident'           => { Text => '1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1', Time => '1 1 1 0 1 0' },
            'Incident::Followup' => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'Problem'            => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'Projekt'            => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'Service'            => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'Sonstiges'          => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
        },
    },
    AgentTicketNote => {
        'domain'                => $InfoFieldsOnly,
        'ew'                    => $InfoFieldsOnly,
        'ew::bibliothek'        => $InfoFieldsOnly,
        'ew::collectd'          => $InfoFieldsOnly,
        'ew::kunde'             => $InfoFieldsOnly,
        'ew::kundebunt'         => $InfoFieldsOnly,
        'ew::nagios'            => $InfoFieldsOnly,
        'ew::otrs'              => $InfoFieldsOnly,
        'ew::pop-db'            => $InfoFieldsOnly,
        'ew::rt'                => $InfoFieldsOnly,
        'Junk'                  => $InfoFieldsOnly,
        'Misc'                  => $InfoFieldsOnly,
        'Postmaster'            => $InfoFieldsOnly,
        'Raw'                   => $InfoFieldsOnly,
        'sd'                    => $InfoFieldsOnly,
        'sd::fcc'               => $InfoFieldsOnly,
        'sd::nfon::incident'    => $InfoFieldsOnly,
        'sd::quelle::change'    => $SDInfoFieldsOnly,
        'sd::quelle::clients'   => $SDInfoFieldsOnly,
        'sd::quelle::incident'  => $SDInfoFieldsOnly,
        'sd::quelle::info'      => $SDInfoFieldsOnly,
        'sd::quelle::knowledge' => $SDInfoFieldsOnly,
        'sd::quelle::problem'   => $SDInfoFieldsOnly,
        'sd::quelle::sr'        => $SDInfoFieldsOnly,
        'technik'               => $InfoFieldsOnly,
        'test'                  => $InfoFieldsOnly,
   },
   AgentTicketPhone => {
       'domain'                => $DefaultFields,
       'ew'                    => $DefaultFields,
       'ew::bibliothek'        => $DefaultFields,
       'ew::collectd'          => $DefaultFields,
       'ew::kunde'             => $DefaultFields,
       'ew::kundebunt'         => $DefaultFields,
       'ew::nagios'            => $DefaultFields,
       'ew::otrs'              => $DefaultFields,
       'ew::pop-db'            => $DefaultFields,
       'ew::rt'                => $DefaultFields,
        'Junk'                  => $DefaultFields,
        'Misc'                  => $DefaultFields,
        'Postmaster'            => $DefaultFields,
        'Raw'                   => $DefaultFields,
        'sd'                    => $DefaultFields,
        'sd::fcc'               => $DefaultFields,
        'sd::nfon::incident'    => $DefaultFields,
        'sd::quelle::change'    => $SD_Quelle_Fields,
        'sd::quelle::clients'   => $SD_Quelle_Fields,
        'sd::quelle::incident'  => {
            'default'            => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'BF'                 => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'CCM'                => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'CCM::Followup'      => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Change'             => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Incident'           => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Incident::Followup' => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Problem'            => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Projekt'            => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Service'            => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
            'Sonstiges'          => { Text => '1 1 0 1 1 1 0 1 1 1 2 1 1 1 0 0', Time => '1 1 1 1 0 0' },
        },
        'sd::quelle::info'      => $SD_Quelle_Fields,
        'sd::quelle::knowledge' => $SD_Quelle_Fields,
        'sd::quelle::problem'   => $SD_Quelle_Fields,
        'sd::quelle::sr'        => $SD_Quelle_Fields,
        'technik'               => $DefaultFields,
        'test'                  => {
            'default'            => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'BF'                 => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'CCM'                => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'CCM::Followup'      => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'Change'             => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'Incident'           => { Text => '1 1 1 1 1 1 0 1 1 1 1 1 1 1 1 1', Time => '1 1 1 0 1 0' },
            'Incident::Followup' => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'Problem'            => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'Projekt'            => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'Service'            => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
            'Sonstiges'          => { Text => '1 1 0 1 1 1 0 1 1 1 1 1 1 1 0 0', Time => '1 0 0 0 0 0' },
        },
    },
};

#my $a = $FreeFields->{AgentTicketPhone}->{ew}->{default}->{Text};

# Check for AgentTicketPhone
for my $Module ( sort keys %$FreeFields ) {
#next;
    my $Config = $Self->{ConfigObject}->Get("Ticket::Frontend::$Module");
    my $ModuleFields = $FreeFields->{$Module};
    for my $Queue ( sort keys %$ModuleFields ) {
        my $TicketTypeFields = $ModuleFields->{$Queue};
        for my $Type ( sort keys %$TicketTypeFields ) {
            my $FreeTextOptions = $Self->{QueueObject}->GetFreeTextOptions(
                Config => $Config->{TicketFreeText},
                Type   => $Type,
                Queue  => $Queue,
            );
            $Self->Is(
                "@$FreeTextOptions",
                $TicketTypeFields->{$Type}->{Text},
                "FreeText: Module:$Module: Type:$Type: Queue:$Queue:",
            );

            my $FreeTimeOptions = $Self->{QueueObject}->GetFreeTimeOptions(
                Config => $Config->{TicketFreeTime},
                Type   => $Type,
                Queue  => $Queue,
            );
            $Self->Is(
                "@$FreeTimeOptions",
                $TicketTypeFields->{$Type}->{Time},
                "FreeTime: Module:$Module: Type:$Type: Queue:$Queue:",
            );
        }
    }
}

# No Queue defined
my $Config = $Self->{ConfigObject}->Get("Ticket::Frontend::AgentTicketPhone");
my $FreeTextOptions = $Self->{QueueObject}->GetFreeOptions(
    Config       => $Config->{TicketFreeText},
    Type   => 'Incident',
    WhichOptions => 'Text',
);
my $FreeTimeOptions = $Self->{QueueObject}->GetFreeOptions(
    Config       => $Config->{TicketFreeTime},
    Type   => 'Incident',
    WhichOptions => 'Time',
);
$Self->Is(
    "@$FreeTextOptions",
    '1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 1',
    "FreeText: ",
);
$Self->Is(
    "@$FreeTimeOptions",
    '1 1 1 0 1 0',
    "FreeTime: ",
);


my %MandatoryResult = (
    '1'  => '',
    '2'  => '',
    '3'  => '',
    '4'  => '',
    '5'  => '',
    '6'  => '',
    '7'  => '',
    '8'  => '',
    '9'  => '',
    '10' => '',
    '11' => 'sd::quelle::incident',
    '12' => '',
    '13' => '',
    '14' => '',
    '15' => '',
    '16' => '',
);
for ( 1 .. 16 ) {
    my @Queues = $Self->{QueueObject}->GetFreeMandatoryQueues(
        Key        => $_,
        TicketType => 'default',
        Config     => {
            '1'  => '2', '2'  => '2', '3'  => '2', '4'  => '2', '5'  => '2',
            '6'  => '2', '7'  => '2', '8'  => '2', '9'  => '2', '10' => '2',
            '11' => '2', '12' => '2', '13' => '2', '14' => '2', '15' => '2',
            '16' => '2',
        },
    );
    $Self->Is(
        "@Queues",
        $MandatoryResult{$_},
        "Mandatory Queues: default: $_",
    );
}

1;
