# --
# Kernel/System/Ticket/Event/TicketCreateNorisAutoLinkObject.pm -
# Auto Create Linking to Confitems and Leitungen
# Copyright (C) 2009 noris network AG, http://www.noris.net/
# --
# $Id$
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::System::Ticket::Event::TicketCreateNorisAutoLinkObject;

use strict;
use warnings;
use Kernel::Noris::kundebunt ();

use vars qw($VERSION);
$VERSION = qw($Revision: 2.3.3 $) [1];

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # get needed objects
    for (qw(ConfigObject LinkObject TicketObject LogObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    return $Self;
}

sub Run {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for (qw(TicketID Event Config UserID)) {
        if ( !$Param{$_} ) {
            $Self->{LogObject}->Log( Priority => 'error', Message => "Need $_!" );
            return;
        }
    }

    my %Ticket = $Self->{TicketObject}->TicketGet( TicketID => $Param{TicketID} );
    my $Title = $Ticket{Title};
    my $CustomerID = $Ticket{CustomerID};

    # ConfItems
    my $SearchList = Kernel::Noris::kundebunt::kundebunt_client(
        ConfigObject => $Self->{ConfigObject},
        Method       => 'confitems',
        Params       => [ ( kunde => $CustomerID ) ],
    );

    # $SearchList = [{ id => 216, kunde => "nureg", name => "Kobil SecOVID" }]
    for my $LO ( @{ $SearchList } ) {
        if ( $Title =~ m/\b\Q$LO->{name}\E\b/i ) {
            $Self->{LinkObject}->LinkAdd(
                SourceObject => 'Ticket',
                SourceKey    => $Param{TicketID},
                TargetObject => 'Confitem',
                TargetKey    => $LO->{id},
                Type         => 'Normal',
                State        => 'Valid',
                UserID       => 1,
            );
        }
    }

    # Leitungen
    $SearchList = Kernel::Noris::kundebunt::kundebunt_client(
        ConfigObject => $Self->{ConfigObject},
        Method       => 'leitung',
        Params       => [ ( kunde => $CustomerID ) ],
    );

    # $SearchList = [ { id   => 24,             art          => "10BaseT",  carrier    => 42, kunde_info => "consors",
    #                   name => "10M-COL1-DTA", name_carrier => "51X/2203", name_kunde => undef } ]
    for my $LO ( @{ $SearchList } ) {
        if ( $Title =~ m/\b\Q$LO->{name}\E\b/i ) {
            $Self->{LinkObject}->LinkAdd(
                SourceObject => 'Ticket',
                SourceKey    => $Param{TicketID},
                TargetObject => 'Leitung',
                TargetKey    => $LO->{id},
                Type         => 'Normal',
                State        => 'Valid',
                UserID       => 1,
            );
        }
    }

    return 1;
}

1;
