# --
# Kernel/System/Ticket/Event/NorisForcePriority.pm - Force Priority
# Copyright (C)2009 noris network AG, http://www.noris.net/
# --
# $Id$
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl-2.0.txt.
# --

package Kernel::System::Ticket::Event::NorisForcePriority;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 0.0.1 $) [1];

use Kernel::System::State;

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # get needed objects
    for (qw(ConfigObject DBObject QueueObject TicketObject LogObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    # Needs DBObject, ConfigObject and LogObject
    $Self->{StateObject} = Kernel::System::State->new( %{$Self} );

    return $Self;
}

sub Run {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for (qw(TicketID UserID Event PreviousStateType)) {
        if ( !$Param{$_} ) {
            $Self->{LogObject}->Log( Priority => 'error', Message => "Need $_!" );
            return;
        }
    }
    
    # get ticket
    my %Ticket = $Self->{TicketObject}->TicketGet(
        TicketID => $Param{TicketID},
    );

    # check if force priority is set
    my %Queue = $Self->{QueueObject}->QueueGet( ID => $Self->{TicketObject}->TicketQueueID( TicketID => $Param{TicketID} ) );
    my @QueueSearchNames = $Self->{QueueObject}->_GetQueueSearchKeys($Queue{'Name'});
    my $ForcePrioQueues  = $Self->{ConfigObject}->Get('ForcePriorityQueues');

    my $ForcePriority = 0;
    for (@QueueSearchNames) {
        if ( defined $ForcePrioQueues->{$_} && $ForcePrioQueues->{$_} ) {
            $ForcePriority = 1;
            last;
        }
    }
    return unless $ForcePriority;

    # check priority 
    if (   defined $Ticket{StateType}
        && $Ticket{StateType} eq 'closed'
        && $Ticket{Priority} == 0 )
    {

        # this ticket has been closed and has not a Priority Set
        # Action: Re-Open Ticket
        my %State = $Self->{StateObject}->StateGet( Name => 'open' );

        $Self->{TicketObject}->StateSet(
            TicketID => $Param{TicketID},
            StateID  => $State{ID},
            UserID   => $Param{UserID},
        );

        # set user id
        $Self->{TicketObject}->OwnerSet(
            TicketID  => $Param{TicketID},
            UserID    => $Param{UserID},
            NewUserID => $Param{UserID},
        );

        # Set lock
        $Self->{TicketObject}->LockSet(
            Lock     => 'lock',
            TicketID => $Param{TicketID},
            UserID   => $Param{UserID},
        );

    }

    return 1;
}

1;
