# --
# Kernel/System/Ticket/Event/NorisCheckLinkObjects.pm - Check Link Objects
# Copyright (C)2009 noris network AG, http://www.noris.net/
# --
# $Id$
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl-2.0.txt.
# --

package Kernel::System::Ticket::Event::NorisCustomerChangeCheckLinkObjects;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 0.0.1 $) [1];

use Kernel::System::State;
use Kernel::Noris::kundebunt ();

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # get needed objects
    for (qw(ConfigObject TicketObject LogObject LinkObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    return $Self;
}

sub Run {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for (qw(TicketID UserID Event)) {
        if ( !$Param{$_} ) {
            $Self->{LogObject}->Log( Priority => 'error', Message => "Need $_!" );
            return;
        }
    }

    ## get ticket
    my %Ticket = $Self->{TicketObject}->TicketGet(
        TicketID => $Param{TicketID},
    );

    my $TicketLinkList = $Self->{LinkObject}->LinkListWithData(
        Object    => 'Ticket',
        Key       => $Param{TicketID},
        State     => 'Valid',
        UserID    => 1,
    );

    # Get all Objects that have to be relinked
    my $LinkObjectRelink = $Self->{ConfigObject}->Get('LinkObject::ToCheck');

    # Object = Confitem
    for my $LinkObj ( keys %{ $LinkObjectRelink } ) {

        # LinkType = Normal
        for my $LinkType ( keys %{ $TicketLinkList->{$LinkObj} } ) {

            # LinkDirection = Source
            for my $LinkDirection ( keys %{ $TicketLinkList->{$LinkObj}->{$LinkType} } ) {

                # LinkID = 42
                for my $LinkID ( keys %{ $TicketLinkList->{$LinkObj}->{$LinkType}->{$LinkDirection} } ) {

                    # Delete old link
                    $Self->{LinkObject}->LinkDelete(
                        Object1 => 'Ticket',
                        Key1    => $Param{TicketID},
                        Object2 => $LinkObj,
                        Key2    => $LinkID,
                        Type    => 'Normal',
                        UserID  => 1,
                    );

                    my $LinkData = $TicketLinkList->{$LinkObj}->{$LinkType}->{$LinkDirection}->{$LinkID};
                    my $NewCustomerObjects = Kernel::Noris::kundebunt::kundebunt_client(
                        ConfigObject => $Self->{ConfigObject},
                        Method       => $LinkObjectRelink->{$LinkObj},
                        Params       => [
                            ( kunde => $Ticket{CustomerID}, ),
                            ( name => $LinkData->{name}, )
                        ],
                    );

                    # check if there is a similar Link Object
                    if ( scalar @{ $NewCustomerObjects } ) {

                        # Delete old link
                        $Self->{LinkObject}->LinkAdd(
                            SourceObject => 'Ticket',
                            SourceKey    => $Param{TicketID},
                            TargetObject => $LinkObj,
                            TargetKey    => $NewCustomerObjects->[0]->{id},
                            Type         => 'Normal',
                            State        => 'Valid',
                            UserID       => 1,
                        );
                    }

                }
            }
        }
    }


    return 1;
}

1;
