# --
# Kernel/System/Ticket/Event/NorisCheckLinkObjects.pm - Check Link Objects
# Copyright (C)2009 noris network AG, http://www.noris.net/
# --
# $Id$
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl-2.0.txt.
# --

package Kernel::System::Ticket::Event::NorisCheckLinkObjects;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 0.0.1 $) [1];

use Kernel::System::State;
use Kernel::Noris::kundebunt ();

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # get needed objects
    for (qw(ConfigObject DBObject TicketObject LogObject LinkObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    # Needs DBObject, ConfigObject and LogObject
    $Self->{StateObject} = Kernel::System::State->new( %{$Self} );

    return $Self;
}

sub Run {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for (qw(TicketID UserID Event PreviousStateType)) {
        if ( !$Param{$_} ) {
            $Self->{LogObject}->Log( Priority => 'error', Message => "Need $_!" );
            return;
        }
    }

    # get ticket
    my %Ticket = $Self->{TicketObject}->TicketGet( TicketID => $Param{TicketID}, );
    return unless defined $Ticket{StateType};
    return unless $Ticket{StateType} eq 'closed';

    my $HasOpenLinkObjects = $Self->{TicketObject}->TicketHasOpenLinkObjects(
        CustomerID => $Ticket{CustomerID},
        TicketID   => $Param{TicketID},
        Queue      => $Ticket{Queue},
    );

    if ($HasOpenLinkObjects) {

        # this ticket has been closed and the Customer has CIs
        # Action: Re-Open Ticket
        my %State = $Self->{StateObject}->StateGet( Name => 'open' );

        # set state
        $Self->{TicketObject}->StateSet(
            TicketID => $Param{TicketID},
            StateID  => $State{ID},
            UserID   => 1,
        );

        # set user id
        $Self->{TicketObject}->OwnerSet(
            TicketID  => $Param{TicketID},
            UserID    => 1,
            NewUserID => $Param{UserID},
        );

        # Set lock
        $Self->{TicketObject}->LockSet(
            Lock     => 'lock',
            TicketID => $Param{TicketID},
            UserID   => 1,
        );
    }

    return 1;
}

1;
