# --
# Kernel/System/Ticket/Event/TicketEscalationIndex.pm - update article search index
# Copyright (C) 2001-2009 OTRS AG, http://otrs.org/
# --
# $Id$
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::System::Ticket::Event::NorisAddonIncident;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 2.3.3 $) [1];

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # get needed objects
    for (qw(ConfigObject TicketObject LogObject TimeObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    return $Self;
}

sub Run {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for (qw(TicketID Event Config)) {
        if ( !$Param{$_} ) {
            $Self->{LogObject}->Log( Priority => 'error', Message => "Need $_!" );
            return;
        }
    }

    my %Ticket = $Self->{TicketObject}->TicketGet(
        TicketID => $Param{TicketID},
        UserID   => 1,
    );

    # do no escalations on (merge|close|remove) tickets
    return 1 if $Ticket{StateType} =~ /^(merge|close|remove)/i;
    return 1 if $Ticket{Type} !~ /^Incident$/i;

    # update escalation times with 0
    my $IncidentTimes = $Self->{ConfigObject}->Get('Addon::Incident');
    # 'Start'    => 'TicketFreeTime2', Response' => 'TicketFreeTime5',

    unless ( $Ticket{ $IncidentTimes->{'Start'}->{Key} } ) {
        my $Counter = $IncidentTimes->{'Start'}->{Key};
        $Counter =~ s/^TicketFreeTime//;

        my ( $Sec, $Min, $Hour, $Day, $Month, $Year, $WeekDay ) =
          $Self->{TimeObject}->SystemTime2Date(
              SystemTime => $Self->{TimeObject}->SystemTime(),
          );

        $Self->{TicketObject}->TicketFreeTimeSet(
            'Counter' => $Counter,
            'Prefix'  => 'TicketFreeTime',
            'TicketFreeTime' . $Counter . 'Year'   => $Year,
            'TicketFreeTime' . $Counter . 'Month'  => $Month,
            'TicketFreeTime' . $Counter . 'Day'    => $Day,
            'TicketFreeTime' . $Counter . 'Hour'   => $Hour,
            'TicketFreeTime' . $Counter . 'Minute' => $Min,
            'TicketID' => $Param{TicketID},
            'UserID'   => 1,
        );
        return 1;
    }

    unless ( $Ticket{ $IncidentTimes->{'Response'}->{Key} } ) {
        my $Counter = $IncidentTimes->{'Response'}->{Key};
        $Counter =~ s/^TicketFreeTime//;

        # check if first response is already done
        my %FirstResponseDone = $Self->{TicketObject}->_TicketGetFirstResponse(
            TicketID => $Ticket{TicketID},
            Ticket   => \%Ticket,
        );

        # update first response time to 0
        if ($FirstResponseDone{FirstResponse}) {
            my ( $Sec, $Min, $Hour, $Day, $Month, $Year, $WeekDay ) =
              $Self->{TimeObject}->SystemTime2Date(
                  SystemTime => $Self->{TimeObject}->TimeStamp2SystemTime(
                      String => $FirstResponseDone{FirstResponse},
                  ),
              );

            $Self->{TicketObject}->TicketFreeTimeSet(
                'Counter'               => $Counter,
                'Prefix'                => 'TicketFreeTime',
                'TicketFreeTime' . $Counter . 'Year'   => $Year,
                'TicketFreeTime' . $Counter . 'Month'  => $Month,
                'TicketFreeTime' . $Counter . 'Day'    => $Day,
                'TicketFreeTime' . $Counter . 'Hour'   => $Hour,
                'TicketFreeTime' . $Counter . 'Minute' => $Min,
                'TicketID'              => $Param{TicketID},
                'UserID'                => 1,
            );
            return 1;
        }
    }

    return 1;
}

1;
