package Kernel::System::PostMaster::Filter::InterTicket;

use strict;
use vars qw($VERSION);

use Data::Dump qw(pp);

sub new {
    my $Type = shift;
    my %Param = @_;

    # allocate new hash for object
    my $Self = {};
    bless ($Self, $Type);

    $Self->{Debug} = $Param{Debug} || 0;

    # get needed opbjects
    foreach (qw(ConfigObject LogObject DBObject MainObject TicketObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }
    $Self->{LinkObject} = Kernel::System::LinkObject->new(%Param);

    return $Self;
}

sub Run {
    my $Self = shift;
    my %Param = @_;
    my $GetParam = $Param{GetParam};
    # get config options
#     if ($Param{JobConfig} && ref($Param{JobConfig}) eq 'HASH') {
#         %Config = %{$Param{JobConfig}};
#         if ($Config{Match}) {
#             %Match = %{$Config{Match}};
#         }
#         if ($Config{Set}) {
#             %Set = %{$Config{Set}};
#         }
#     }
    # match 'Match => ???' stuff
    
    my $From = $GetParam->{From};
    my $EnvelopeSenderDomain = $Self->{ConfigObject}->{EnvelopeSenderDomain};
    my $RTEnvelopeSenderDomain = $Self->{ConfigObject}->{RTEnvelopeSenderDomain};
    
    if ( $EnvelopeSenderDomain
         and $From =~ /(^|<)(\d+)@(.*?)(>|$)/ 
         and $3 eq $EnvelopeSenderDomain ) {
        # OK, this is a ticket from another otrs ticket. Thus, it's internal.
        $GetParam->{'X-OTRS-ArticleType'} = 
            $GetParam->{'X-OTRS-FollowUp-ArticleType'} = 
            'email-internal';
        $Self->{LogObject}->Log(Priority => 'debug', Message => 'article type set to email-internal');
        
        # Check whether the other ticket is a "main" ticket
        # In which case we treat the email as from a customer (else as from an agent).
        my $LinkList  = $Self->{LinkObject}->LinkList(
                    Object    => 'Ticket',
                    Key       => $Param{TicketID},
                    Object2   => 'Ticket',
                    State     => 'Valid',
                    Type      => 'MainSub',
                    Direction => 'Source',
                    UserID    => 1,
                );
        $GetParam->{'X-OTRS-FollowUp-SenderType'} =
            $GetParam->{'X-OTRS-SenderType'} = 
                ($LinkList->{Ticket}->{MainSub} && %{$LinkList->{Ticket}->{MainSub}})
                ? 'customer' : 'agent';
        $Self->{LogObject}->Log(Priority => 'debug', Message => "LinkList: " . pp(%$LinkList));
        $Self->{LogObject}->Log(Priority => 'debug', Message => "customer type set to $GetParam->{'X-OTRS-FollowUp-SenderType'}");
    }
    elsif ( defined $RTEnvelopeSenderDomain 
            and $GetParam->{'Return-Path'} 
            and $GetParam->{'Return-Path'} =~ /(^|<)(\d+)@(.*?)(>|$)/
            and $3 eq $RTEnvelopeSenderDomain ) {
        # OK, this is a ticket from an RT ticket. Thus, it's internal.
        $GetParam->{'X-OTRS-ArticleType'} = 
            $GetParam->{'X-OTRS-FollowUp-ArticleType'} = 
            'email-internal';
        $Self->{LogObject}->Log(Priority => 'debug', Message => 'article type set to email-internal');
        
        # Check whether the other ticket is a "main" ticket
        # In which case we treat the email as from a customer (else as from an agent).
        $GetParam->{'X-OTRS-FollowUp-SenderType'} =
            $GetParam->{'X-OTRS-SenderType'} = 'agent';
        $Self->{LogObject}->Log(Priority => 'debug', Message => "customer type set to $GetParam->{'X-OTRS-FollowUp-SenderType'}");
        # Change the reply-To-address
        $GetParam->{ReplyTo} = $GetParam->{'Return-Path'};
    }
    return 1;
}

1;