package Kernel::System::PostMaster::Filter::CreateRTLinks;

use strict;
use vars qw($VERSION);

use Data::Dump qw(pp);

sub new {
    my $Type = shift;
    my %Param = @_;

    # allocate new hash for object
    my $Self = {};
    bless ($Self, $Type);

    $Self->{Debug} = $Param{Debug} || 0;

    # get needed opbjects
    foreach (qw(ConfigObject LogObject DBObject MainObject TicketObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }
    $Self->{LinkObject} = Kernel::System::LinkObject->new(%Param);

    return $Self;
}

sub Run {
    my $Self = shift;
    my %Param = @_;
    my $GetParam = $Param{GetParam};
    my $TicketID = $Param{TicketID};
    # get config options
#     if ($Param{JobConfig} && ref($Param{JobConfig}) eq 'HASH') {
#         %Config = %{$Param{JobConfig}};
#         if ($Config{Match}) {
#             %Match = %{$Config{Match}};
#         }
#         if ($Config{Set}) {
#             %Set = %{$Config{Set}};
#         }
#     }
    # match 'Match => ???' stuff

    my $From = $GetParam->{From};
    my $EnvelopeSenderDomain = $Self->{ConfigObject}->{EnvelopeSenderDomain};
    my $RTEnvelopeSenderDomain = $Self->{ConfigObject}->{RTEnvelopeSenderDomain};

    if ( defined $RTEnvelopeSenderDomain
            and $GetParam->{'Return-Path'}
            and $GetParam->{'Return-Path'} =~ /(^|<)(\d+)@(.*?)(>|$)/
            and $3 eq $RTEnvelopeSenderDomain ) {
        # OK, this is a ticket from an RT ticket. Look up if there's already a link to that ticket
        my $RT = $2;
        my %LinkList = $Self->{LinkObject}->LinkKeyList(
                Object1    => 'Ticket',
                Key1      => $TicketID,
                Object2   => 'RT',
                State     => 'Valid',
                Type      => 'RT-Followup',
                Direction => 'Both',
                UserID    => 1,
            );

        # return if there's already a link
        return 1 if exists $LinkList{$RT};

        # No, so let's create the link. This ticket is the target the contact is the envelope sender.
        my %ArticleIndex = $Self->{TicketObject}->ArticleIndex(TicketID => $TicketID);
        if (keys %ArticleIndex <= 1) {
            $Self->{LinkObject}->LinkAdd(
                SourceObject => 'RT',
                SourceKey => $RT,
                TargetObject => 'Ticket',
                TargetKey => $TicketID,
                Type => 'RT-Followup',
                State => 'Valid',
                UserID => 1,
            );
        }
        else {
            $Self->{LinkObject}->LinkAdd(
                SourceObject => 'Ticket',
                SourceKey => $TicketID,
                TargetObject => 'RT',
                TargetKey => $RT,
                Type => 'RT-Followup',
                State => 'Valid',
                UserID => 1,
            );
        }
    }
    return 1;
}

1;