# --
# Kernel/System/LinkObject/DocuShare.pm - to link docushare objects to tickets

package Kernel::System::LinkObject::DocuShare;

use lib '/usr/pop/lib';
use Docushare;
use strict;
use warnings;
use Carp;
use Data::Dump qw(pp);
# use Kernel::System::Ticket;

use vars qw($VERSION);
$VERSION = qw($Revision$) [1];

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # check needed objects
    for (qw(LogObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    return $Self;
}

=item LinkListWithData()

fill up the link list with data

    $Success = $LinkObjectBackend->LinkListWithData(
        LinkList => $HashRef,
        UserID   => 1,
    );

=cut

sub docushare_properties {
    my ($UserID, $ds_id) = @_;
#     my $username = UserObject->
#     confess "acltest failed\n" unless eval {Docushare::acltest($ds_id, "mir")};
#     return undef unless eval {Docushare::acltest($ds_id, $UserID)};

    my $full_ds_id = $ds_id;
    $ds_id =~ s/-\d*$//;

    my ($displayname, $creationdate, $contenttype);
    eval {
        ( $displayname, $creationdate, $contenttype ) =
          Docushare::propget( $ds_id, ( 'displayname', 'creationdate', 'getcontenttype' ) );
    };
    if ( $@ || !defined $displayname ) {
        return undef;
    }

    return { id => $full_ds_id,
             displayname => $displayname,
             creationdate => substr($creationdate, 0, 10), 
             contenttype => $contenttype,
             url => docushare_url($ds_id) };
}
             
sub docushare_url {
    my ($ds_id) = @_;
    return "http://docushare.noris.de/Get/File-$ds_id";
}

# sub docushare_index_list {
#     my ($props) = @_;
#     return [] unless defined $props;
#     my $anchor = "<a href=\"$props->{url}\">";
#     my $dn_link = $anchor . quote($props->{displayname}) . "</a>";
#     my $type_link = $anchor . quote($props->{contenttype}) . "</a>";
#     return [$props->{id},
#             $dn_link,
#             $type_link,
#             substr($props->{creationdate}, 10)];
# }

sub LinkListWithData {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for my $Argument (qw(LinkList UserID)) {
        if ( !$Param{$Argument} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $Argument!",
            );
            return;
        }
    }

    # check link list
    if ( ref $Param{LinkList} ne 'HASH' ) {
        $Self->{LogObject}->Log(
            Priority => 'error',
            Message  => 'LinkList must be a hash reference!',
        );
        return;
    }

    for my $LinkType ( keys %{ $Param{LinkList} } ) {

        for my $Direction ( keys %{ $Param{LinkList}->{$LinkType} } ) {
            for my $ds_id ( keys %{ $Param{LinkList}->{$LinkType}->{$Direction} } ) {
                my $props = docushare_properties($Param{UserID}, $ds_id);
                $Param{LinkList}->{$LinkType}->{$Direction}->{$ds_id} = $props if defined $props;
            }
        }
    }
    return 1;
}

=item ObjectDescriptionGet()

return a hash of object descriptions

Return
    %Description = (
        Normal => "Ticket# 1234455",
        Long   => "Ticket# 1234455: The Ticket Title",
    );

    %Description = $LinkObject->ObjectDescriptionGet(
        Key     => 123,
        Mode    => 'Temporary',  # (optional)
        UserID  => 1,
    );

=cut

sub ObjectDescriptionGet {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for my $Argument (qw(Object Key UserID)) {
        if ( !$Param{$Argument} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $Argument!",
            );
            return;
        }
    }

    # create description
    my %Description = (
        Normal => 'DocuShare',
        Long   => 'DocuShare',
    );

    return %Description if $Param{Mode} && $Param{Mode} eq 'Temporary';

#     # get ticket
#     my %Ticket = $Self->{TicketObject}->TicketGet(
#         TicketID => $Param{Key},
#         UserID   => 1,
#     );
# 
#     return if !%Ticket;

    # create description
    my $props = docushare_properties($Param{UserID}, $Param{Key});
    %Description = (
        Normal => "DS: $Param{Key}",
        Long   => "DocuShare: $Param{Key}: " . $props->{displayname},
    );

    return %Description;
}

=item ObjectSearch()

return a hash list of the search results

Return
    $SearchList = {
        NOTLINKED => {
            Source => {
                12  => $DataOfItem12,
                212 => $DataOfItem212,
                332 => $DataOfItem332,
            },
        },
    };

    $SearchList = $LinkObjectBackend->ObjectSearch(
        SubObject    => 'Bla',     # (optional)
        SearchParams => $HashRef,  # (optional)
        UserID       => 1,
    );

=cut

# FIXME: Da steht bloß der Code für Tickets drin :-)
sub ObjectSearch {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    if ( !$Param{UserID} ) {
        $Self->{LogObject}->Log(
            Priority => 'error',
            Message  => 'Need UserID!',
        );
        return;
    }

    my %SearchList;
    my $id = $Param{SearchParams}->{id};
    my $props = docushare_properties($Param{UserID}, $id);
    return undef unless defined $props;

    $SearchList{NOTLINKED}->{Source}->{$id} = $props if defined $props;
    return \%SearchList;
}

=item LinkAddPre()

link add pre event module

    $True = $LinkObject->LinkAddPre(
        Key          => 123,
        SourceObject => 'Ticket',
        SourceKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

    or

    $True = $LinkObject->LinkAddPre(
        Key          => 123,
        TargetObject => 'Ticket',
        TargetKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

=cut

sub LinkAddPre {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for my $Argument (qw(Key Type State UserID)) {
        if ( !$Param{$Argument} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $Argument!",
            );
            return;
        }
    }

    return 1 if $Param{State} eq 'Temporary';

    return 1;
}

=item LinkAddPost()

link add pre event module

    $True = $LinkObject->LinkAddPost(
        Key          => 123,
        SourceObject => 'Ticket',
        SourceKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

    or

    $True = $LinkObject->LinkAddPost(
        Key          => 123,
        TargetObject => 'Ticket',
        TargetKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

=cut

sub LinkAddPost {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for my $Argument (qw(Key Type State UserID)) {
        if ( !$Param{$Argument} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $Argument!",
            );
            return;
        }
    }

    return 1 if $Param{State} eq 'Temporary';

#     if ( $Param{SourceObject} && $Param{SourceObject} eq 'Ticket' && $Param{SourceKey} ) {
# 
#         # lookup ticket number
#         my $TicketNumber = $Self->{TicketObject}->TicketNumberLookup(
#             TicketID => $Param{SourceKey},
#             UserID   => $Param{UserID},
#         );
# 
#         # add ticket history entry
#         $Self->{TicketObject}->HistoryAdd(
#             TicketID     => $Param{Key},
#             CreateUserID => $Param{UserID},
#             HistoryType  => 'TicketLinkAdd',
#             Name         => "\%\%$TicketNumber\%\%$Param{SourceKey}\%\%$Param{Key}",
#         );
# 
#         # ticket event
#         $Self->{TicketObject}->TicketEventHandlerPost(
#             Event    => 'TicketSlaveLinkAdd' . $Param{Type},
#             UserID   => $Param{UserID},
#             TicketID => $Param{Key},
#         );
# 
#         return 1;
#     }
# 
#     if ( $Param{TargetObject} && $Param{TargetObject} eq 'Ticket' && $Param{TargetKey} ) {
# 
#         # lookup ticket number
#         my $TicketNumber = $Self->{TicketObject}->TicketNumberLookup(
#             TicketID => $Param{TargetKey},
#             UserID   => $Param{UserID},
#         );
# 
#         # add ticket history entry
#         $Self->{TicketObject}->HistoryAdd(
#             TicketID     => $Param{Key},
#             CreateUserID => $Param{UserID},
#             HistoryType  => 'TicketLinkAdd',
#             Name         => "\%\%$TicketNumber\%\%$Param{TargetKey}\%\%$Param{Key}",
#         );
# 
#         # ticket event
#         $Self->{TicketObject}->TicketEventHandlerPost(
#             Event    => 'TicketMasterLinkAdd' . $Param{Type},
#             UserID   => $Param{UserID},
#             TicketID => $Param{Key},
#         );
# 
#         return 1;
#     }

    return 1;
}

=item LinkDeletePre()

link delete pre event module

    $True = $LinkObject->LinkDeletePre(
        Key          => 123,
        SourceObject => 'Ticket',
        SourceKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

    or

    $True = $LinkObject->LinkDeletePre(
        Key          => 123,
        TargetObject => 'Ticket',
        TargetKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

=cut

sub LinkDeletePre {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for my $Argument (qw(Key Type State UserID)) {
        if ( !$Param{$Argument} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $Argument!",
            );
            return;
        }
    }

    return 1 if $Param{State} eq 'Temporary';

    return 1;
}

=item LinkDeletePost()

link delete post event module

    $True = $LinkObject->LinkDeletePost(
        Key          => 123,
        SourceObject => 'Ticket',
        SourceKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

    or

    $True = $LinkObject->LinkDeletePost(
        Key          => 123,
        TargetObject => 'Ticket',
        TargetKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

=cut

sub LinkDeletePost {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for my $Argument (qw(Key Type State UserID)) {
        if ( !$Param{$Argument} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $Argument!",
            );
            return;
        }
    }

    return 1 if $Param{State} eq 'Temporary';

#     if ( $Param{SourceObject} && $Param{SourceObject} eq 'Ticket' && $Param{SourceKey} ) {
# 
#         # lookup ticket number
#         my $TicketNumber = $Self->{TicketObject}->TicketNumberLookup(
#             TicketID => $Param{SourceKey},
#             UserID   => $Param{UserID},
#         );
# 
#         # add ticket history entry
#         $Self->{TicketObject}->HistoryAdd(
#             TicketID     => $Param{Key},
#             CreateUserID => $Param{UserID},
#             HistoryType  => 'TicketLinkDelete',
#             Name         => "\%\%$TicketNumber\%\%$Param{SourceKey}\%\%$Param{Key}",
#         );
# 
#         # ticket event
#         $Self->{TicketObject}->TicketEventHandlerPost(
#             Event    => 'TicketSlaveLinkDelete' . $Param{Type},
#             UserID   => $Param{UserID},
#             TicketID => $Param{Key},
#         );
# 
#         return 1;
#     }
# 
#     if ( $Param{TargetObject} && $Param{TargetObject} eq 'Ticket' && $Param{TargetKey} ) {
# 
#         # lookup ticket number
#         my $TicketNumber = $Self->{TicketObject}->TicketNumberLookup(
#             TicketID => $Param{TargetKey},
#             UserID   => $Param{UserID},
#         );
# 
#         # add ticket history entry
#         $Self->{TicketObject}->HistoryAdd(
#             TicketID     => $Param{Key},
#             CreateUserID => $Param{UserID},
#             HistoryType  => 'TicketLinkDelete',
#             Name         => "\%\%$TicketNumber\%\%$Param{TargetKey}\%\%$Param{Key}",
#         );
# 
#         # ticket event
#         $Self->{TicketObject}->TicketEventHandlerPost(
#             Event    => 'TicketMasterLinkDelete' . $Param{Type},
#             UserID   => $Param{UserID},
#             TicketID => $Param{Key},
#         );
# 
#         return 1;
#     }

    return 1;
}

1;
