# --
# Kernel/System/LinkObject/Confitem.pm - to link confitem objects to tickets

package Kernel::System::LinkObject::Confitem;
use Kernel::Noris::kundebunt ();

use strict;
use warnings;

# use Kernel::System::Ticket;

use vars qw($VERSION);
$VERSION = qw($Revision$) [1];

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # check needed objects
    for (qw(DBObject ConfigObject LogObject MainObject EncodeObject TimeObject LinkObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    $Self->{TicketObject} = Kernel::System::Ticket->new( %{$Self} );

    return $Self;
}

=item LinkListWithData()

fill up the link list with data

    $Success = $LinkObjectBackend->LinkListWithData(
        LinkList => $HashRef,
        UserID   => 1,
    );

=cut

sub LinkListWithData {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for my $Argument (qw(LinkList UserID)) {
        if ( !$Param{$Argument} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $Argument!",
            );
            return;
        }
    }

    # check link list
    if ( ref $Param{LinkList} ne 'HASH' ) {
        $Self->{LogObject}->Log(
            Priority => 'error',
            Message  => 'LinkList must be a hash reference!',
        );
        return;
    }

    for my $LinkType ( keys %{ $Param{LinkList} } ) {
        for my $Direction ( keys %{ $Param{LinkList}->{$LinkType} } ) {
            for my $ConfitemNo ( keys %{ $Param{LinkList}->{$LinkType}->{$Direction} } ) {
                for my $id (keys %{ $Param{LinkList}->{$LinkType}->{$Direction} } ) {;
                    my $Rows = $Self->http_client( id => $id );
                    $Param{LinkList}->{$LinkType}->{$Direction}->{$id} = $Rows->[0];
                }
            }
        }
    }

    return 1;
}

=item ObjectDescriptionGet()

return a hash of object descriptions

Return
    %Description = (
        Normal => "Ticket# 1234455",
        Long   => "Ticket# 1234455: The Ticket Title",
    );

    %Description = $LinkObject->ObjectDescriptionGet(
        Key     => 123,
        Mode    => 'Temporary',  # (optional)
        UserID  => 1,
    );

=cut

sub ObjectDescriptionGet {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for my $Argument (qw(Object Key UserID)) {
        if ( !$Param{$Argument} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $Argument!",
            );
            return;
        }
    }

    # create description
    my %Description = (
        Normal => 'Confitem',
        Long   => 'Confitem',
    );

    return %Description if $Param{Mode} && $Param{Mode} eq 'Temporary';

    my $name = ( $Self->http_client( id => $Param{Key} ) )->[0]->{name};

    return if !$name;

    # create description
    %Description = (
        Normal => "CI: $name",
        Long   => "Confitem: $name",
    );

    return %Description;
}

=item ObjectSearch()

return a hash list of the search results

Return
    $SearchList = {
        NOTLINKED => {
            Source => {
                12  => $DataOfItem12,
                212 => $DataOfItem212,
                332 => $DataOfItem332,
            },
        },
    };

    $SearchList = $LinkObjectBackend->ObjectSearch(
        SubObject    => 'Bla',     # (optional)
        SearchParams => $HashRef,  # (optional)
        UserID       => 1,
    );

=cut

sub ObjectSearch {
    my ( $Self, %Param ) = @_;

    my %SearchParams;
    if ( $Param{SearchParams}->{name} ) {
        %SearchParams = ( name => $Param{SearchParams}->{name} );
    }
    if ( $Param{SearchParams}->{kunde} ) {
        %SearchParams = ( kunde => $Param{SearchParams}->{kunde} );
    }

    my $Rows = $Self->http_client(%SearchParams);

    my %SearchList;
    for my $row (@$Rows) {
        $SearchList{NOTLINKED}->{Source}->{ $row->{id} } = $row;
    }
    return \%SearchList;
}

=item LinkAddPre()

link add pre event module

    $True = $LinkObject->LinkAddPre(
        Key          => 123,
        SourceObject => 'Ticket',
        SourceKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

    or

    $True = $LinkObject->LinkAddPre(
        Key          => 123,
        TargetObject => 'Ticket',
        TargetKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

=cut

sub LinkAddPre {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for my $Argument (qw(Key Type State UserID)) {
        if ( !$Param{$Argument} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $Argument!",
            );
            return;
        }
    }

    return 1 if $Param{State} eq 'Temporary';

    return 1;
}

=item LinkAddPost()

link add pre event module

    $True = $LinkObject->LinkAddPost(
        Key          => 123,
        SourceObject => 'Ticket',
        SourceKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

    or

    $True = $LinkObject->LinkAddPost(
        Key          => 123,
        TargetObject => 'Ticket',
        TargetKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

=cut

sub LinkAddPost {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for my $Argument (qw(Key Type State UserID)) {
        if ( !$Param{$Argument} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $Argument!",
            );
            return;
        }
    }

    return 1 if $Param{State} eq 'Temporary';

    my $CIname = ( $Self->http_client( id => $Param{Key} ) )->[0]->{name};

    if (   $Param{SourceObject}
        && $Param{SourceObject} eq 'Ticket'
        && $Param{SourceKey} )
    {

        # add ticket history entry
        $Self->{TicketObject}->HistoryAdd(
            TicketID     => $Param{SourceKey},
            CreateUserID => $Param{UserID},
            HistoryType  => 'TicketLinkAdd',
            Name         => "\%\%CI:$Param{Key}:$CIname",
        );

        return 1;
    }

    if (   $Param{TargetObject}
        && $Param{TargetObject} eq 'Ticket'
        && $Param{TargetKey} )
    {

        # add ticket history entry
        $Self->{TicketObject}->HistoryAdd(
            TicketID     => $Param{TargetKey},
            CreateUserID => $Param{UserID},
            HistoryType  => 'TicketLinkAdd',
            Name         => "\%\%CI:$Param{Key}:$CIname",
        );
        return 1;
    }

    return 1;
}

=item LinkDeletePre()

link delete pre event module

    $True = $LinkObject->LinkDeletePre(
        Key          => 123,
        SourceObject => 'Ticket',
        SourceKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

    or

    $True = $LinkObject->LinkDeletePre(
        Key          => 123,
        TargetObject => 'Ticket',
        TargetKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

=cut

sub LinkDeletePre {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for my $Argument (qw(Key Type State UserID)) {
        if ( !$Param{$Argument} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $Argument!",
            );
            return;
        }
    }

    return 1 if $Param{State} eq 'Temporary';

    return 1;
}

=item LinkDeletePost()

link delete post event module

    $True = $LinkObject->LinkDeletePost(
        Key          => 123,
        SourceObject => 'Ticket',
        SourceKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

    or

    $True = $LinkObject->LinkDeletePost(
        Key          => 123,
        TargetObject => 'Ticket',
        TargetKey    => 321,
        Type         => 'Normal',
        State        => 'Valid',
        UserID       => 1,
    );

=cut

sub LinkDeletePost {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for my $Argument (qw(Key Type State UserID)) {
        if ( !$Param{$Argument} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $Argument!",
            );
            return;
        }
    }

    return 1 if $Param{State} eq 'Temporary';

    my $CIname = ( $Self->http_client( id => $Param{Key} ) )->[0]->{name};

    if (   $Param{SourceObject}
        && $Param{SourceObject} eq 'Ticket'
        && $Param{SourceKey} )
    {

        # add ticket history entry
        $Self->{TicketObject}->HistoryAdd(
            TicketID     => $Param{SourceKey},
            CreateUserID => $Param{UserID},
            HistoryType  => 'TicketLinkDelete',
            Name         => "\%\%CI:$Param{Key}:$CIname",
        );

        return 1;
    }

    if (   $Param{TargetObject}
        && $Param{TargetObject} eq 'Ticket'
        && $Param{TargetKey} )
    {

        # add ticket history entry
        $Self->{TicketObject}->HistoryAdd(
            TicketID     => $Param{TargetKey},
            CreateUserID => $Param{UserID},
            HistoryType  => 'TicketLinkDelete',
            Name         => "\%\%CI:$Param{Key}:$CIname",
        );
        return 1;
    }

    return 1;
}

# Abfrage kundebunt-WebService bzgl. ConfItems,
# Beispielaufruf: my $CIs = $self->http_client( id => '12345' );
sub http_client {
    my $Self = shift;

    return Kernel::Noris::kundebunt::kundebunt_client(
        ConfigObject => $Self->{ConfigObject},
        Method => 'confitems',
        Params => \@_,
    );

}

return 1;
