# --
# Kernel/Output/HTML/TicketOverviewNoris.pm
# Copyright (C) 2001-2009 OTRS AG, http://otrs.org/
# --
# $Id$
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Output::HTML::TicketOverviewNoris;

use strict;
use warnings;

use Kernel::System::CustomerUser;

use vars qw($VERSION);
$VERSION = qw($Revision: 0.0.1 $) [1];

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = \%Param;
    bless( $Self, $Type );

    # get needed objects
    for (
        qw(ConfigObject LogObject DBObject LayoutObject UserID UserObject GroupObject TicketObject MainObject QueueObject)
        )
    {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    $Self->{CustomerUserObject} = Kernel::System::CustomerUser->new(%Param);

    $Self->{NorisViewColumnHeader}
        = $Self->{ConfigObject}->Get('Ticket::Frontend::OverviewNoris')->{ColumnHeader};

    return $Self;
}

sub Run {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for (qw(TicketIDs PageShown StartHit)) {
        if ( !$Param{$_} ) {
            $Self->{LogObject}->Log( Priority => 'error', Message => "Need $_!" );
            return;
        }
    }

    # check if bulk feature is enabled
    my $BulkFeature = 0;
    if ( $Param{Bulk} && $Self->{ConfigObject}->Get('Ticket::Frontend::BulkFeature') ) {
        my @Groups;
        if ( $Self->{ConfigObject}->Get('Ticket::Frontend::BulkFeatureGroup') ) {
            @Groups = @{ $Self->{ConfigObject}->Get('Ticket::Frontend::BulkFeatureGroup') };
        }
        if ( !@Groups ) {
            $BulkFeature = 1;
        }
        else {
            for my $Group (@Groups) {
                next if !$Self->{LayoutObject}->{"UserIsGroup[$Group]"};
                if ( $Self->{LayoutObject}->{"UserIsGroup[$Group]"} eq 'Yes' ) {
                    $BulkFeature = 1;
                    last;
                }
            }
        }
    }

    if ($BulkFeature) {
        $Self->{LayoutObject}->Block(
            Name => 'BulkHead',
            Data => \%Param,
        );
    }

    $Self->{LayoutObject}->Block(
        Name => 'RecordEscalationHeader',
        Data => \%Param,
    );

    $Self->{LayoutObject}->Block(
        Name => 'RecordTicketTitleHeader',
        Data => \%Param,
    );

    my $Output  = '';
    my $Counter = 0;
    for my $TicketID ( @{ $Param{TicketIDs} } ) {
        $Counter++;
        if ( $Counter >= $Param{StartHit} && $Counter < ( $Param{PageShown} + $Param{StartHit} ) ) {

            # get last customer article
            my %Article = $Self->{TicketObject}->ArticleLastCustomerArticle(
                TicketID => $TicketID,
            );

            # escalation human times
            if ( $Article{EscalationTime} ) {
                $Article{EscalationTimeHuman} = $Self->{LayoutObject}->CustomerAgeInHours(
                    Age   => $Article{EscalationTime},
                    Space => ' ',
                );
                $Article{EscalationTimeWorkingTime} = $Self->{LayoutObject}->CustomerAgeInHours(
                    Age   => $Article{EscalationTimeWorkingTime},
                    Space => ' ',
                );
            }

            # customer info (customer name)
            my %CustomerData = ();
            if ( $Article{CustomerUserID} ) {
                %CustomerData = $Self->{CustomerUserObject}->CustomerUserDataGet(
                    User => $Article{CustomerUserID},
                );
            }
            if ( $CustomerData{UserLogin} ) {
                $Article{CustomerName} = $Self->{CustomerUserObject}->CustomerName(
                    UserLogin => $CustomerData{UserLogin},
                );
            }

            # user info
            my %UserInfo = $Self->{UserObject}->GetUserData(
                User   => $Article{Owner},
                Cached => 1
            );

            # seperate each searchresult line by using several css
            if ( $Counter % 2 ) {
                $Article{css} = "searchpassive";
            }
            else {
                $Article{css} = "searchactive";
            }
            $Self->{LayoutObject}->Block(
                Name => 'Record',
                Data => { %Article, %UserInfo },
            );

            # check if bulk feature is enabled
            if ($BulkFeature) {
                $Self->{LayoutObject}->Block(
                    Name => 'Bulk',
                    Data => { %Article, %UserInfo },
                );
            }

            # TicketFreeText
            for ( 1 .. 16 ) {
                $Self->{LayoutObject}->Block(
                    Name => "TicketFreeText$_",
                    Data => {
                        "TicketFreeText$_" => $Article{"TicketFreeText$_"},
                    },
                );
            }

            # TicketFreeTime
            for ( 1 .. 6 ) {
                $Article{ 'TicketFreeTime' . $_ . 'Color' } = '#000';
                if ( defined $Article{ 'TicketFreeTime' . $_ } ) {
                    my $epoch_due = $Self->{TimeObject}->TimeStamp2SystemTime(
                        String => $Article{ 'TicketFreeTime' . $_ }
                      );
                    my $epoch_now    = $Self->{TimeObject}->SystemTime();
                    my $epoch_create = $Article{'CreateTimeUnix'};

                    $Article{ 'TicketFreeTime' . $_ . 'Human' } =
                      $Self->{LayoutObject}->CustomerAgeHumanReadable(
                        Age   => $epoch_due - $epoch_now,
                        Space => ' ',
                      );
                    my $red = 1 - ( $epoch_due - $epoch_now ) / ( $epoch_due - $epoch_create );
                    if ( $red > 1 ) {
                        $red = 1;
                        $Article{ 'TicketFreeTime' . $_ . 'Box1' } = '<strong>';
                        $Article{ 'TicketFreeTime' . $_ . 'Box2' } = '</strong>';
                    }
                    $Article{ 'TicketFreeTime' . $_ . 'Color' } = sprintf '#%02X0000', 255 * $red;
                }
                $Self->{LayoutObject}->Block(
                    Name => 'TicketFreeTime' . $_,
                    Data => { %Article, },
                );
            }

            if ( $Article{EscalationTime} < 60 * 60 * 1 ) {
                $Self->{LayoutObject}->Block(
                    Name => 'RecordEscalationFontStart',
                    Data => { %Article, %UserInfo },
                );
                $Self->{LayoutObject}->Block(
                    Name => 'RecordEscalationFontStop',
                    Data => { %Article, %UserInfo },
                );
            }

            $Self->{LayoutObject}->Block(
                Name => 'RecordTicketTitle',
                Data => { %Article, %UserInfo },
            );
        }
    }

    # check if bulk feature is enabled
    if ($BulkFeature) {
        $Self->{LayoutObject}->Block(
            Name => 'BulkFooter',
            Data => \%Param,
        );
    }

    # use template
    $Output .= $Self->{LayoutObject}->Output(
        TemplateFile => 'AgentTicketOverviewNoris',
        Data => { %Param, Type => $Self->{ViewType}, },
    );

    return $Output;
}

1;
