# --
# Kernel/Output/HTML/TicketMenuLock.pm
# Copyright (C) 2001-2009 OTRS AG, http://otrs.org/
# --
# $Id$
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Output::HTML::TicketMenuLock;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 2.3.3 $) [1];

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # get needed objects
    for (qw(ConfigObject LogObject DBObject LayoutObject UserID TicketObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    return $Self;
}

sub Run {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    if ( !$Param{Ticket} ) {
        $Self->{LogObject}->Log( Priority => 'error', Message => 'Need Ticket!' );
        return;
    }

    # check if frontend module registered, if not, do not show action
    if ( $Param{Config}->{Action} ) {
        my $Module = $Self->{ConfigObject}->Get('Frontend::Module')->{ $Param{Config}->{Action} };
        return $Param{Counter} if !$Module;
    }

    # check permission
    my $AccessOk = $Self->{TicketObject}->Permission(
        Type     => 'lock',
        TicketID => $Param{TicketID},
        UserID   => $Self->{UserID},
        LogNo    => 1,
    );
    return $Param{Counter} if !$AccessOk;

    # check acl
    if (
        !defined $Param{ACL}->{ $Param{Config}->{Action} }
        || $Param{ACL}->{ $Param{Config}->{Action} }
        )
    {
        if ( $Param{Ticket}->{Lock} eq 'lock' ) {
            if ( $Param{Ticket}->{OwnerID} eq $Self->{UserID} ) {
                $Self->{LayoutObject}->Block(
                    Name => 'Menu',
                );
                if ( $Param{Counter} ) {
                    $Self->{LayoutObject}->Block(
                        Name => 'MenuItemSplit',
                    );
                }
                $Self->{LayoutObject}->Block(
                    Name => 'MenuItem',
                    Data => {
                        %{ $Param{Config} },
                        %{ $Param{Ticket} },
                        %Param,
                        Name        => 'Release',
                        Description => 'Release to give it back to the queue!',
                        Link =>
                            'Action=AgentTicketLock&amp;Subaction=Unlock&amp;TicketID=$QData{"TicketID"}',
                    },
                );
                $Param{Counter}++;
            }
            elsif ($Self->{TicketObject}->Permission(
                Type => $Self->{ConfigObject}->Get(
                            'Ticket::Frontend::AgentTicketOwner'
                        )->{'Permission'},
                TicketID => $Param{TicketID},
                UserID   => $Self->{UserID},
                LogNo    => 1,
            )) {
                $Self->{LayoutObject}->Block(
                    Name => 'Menu',
                );
                if ( $Param{Counter} ) {
                    $Self->{LayoutObject}->Block(
                        Name => 'MenuItemSplit',
                    );
                }
                $Self->{LayoutObject}->Block(
                    Name => 'MenuItem',
                    Data => {
                        %{ $Param{Config} },
                        %{ $Param{Ticket} },
                        %Param,
                        Name        => 'Steal',
                        Description => 'Steal a locked ticket',
                        Link =>
                            'Action=AgentTicketLock&amp;Subaction=Lock&amp;TicketID=$QData{"TicketID"}',
                    },
                );
                $Param{Counter}++;
            }
        }
        else {
            $Self->{LayoutObject}->Block(
                Name => 'Menu',
            );
            if ( $Param{Counter} ) {
                $Self->{LayoutObject}->Block(
                    Name => 'MenuItemSplit',
                );
            }
            $Self->{LayoutObject}->Block(
                Name => 'MenuItem',
                Data => {
                    %{ $Param{Config} },
                    %Param,
                    Name        => 'Take',
                    Description => 'Take it to work on it!',
                    Link => 'Action=AgentTicketLock&amp;Subaction=Lock&amp;TicketID=$QData{"TicketID"}',
                },
            );
            $Param{Counter}++;
        }
    }
    return $Param{Counter};
}

1;
