# --
# Kernel/Output/HTML/NavBarTicketSearchProfile.pm
# Copyright (C) 2001-2008 OTRS AG, http://otrs.org/
# --
# $Id$
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl-2.0.txt.
# --

package Kernel::Output::HTML::NavBarNorisTicketSearchProfile;

use strict;
use warnings;
use Kernel::System::SearchProfile;

use vars qw($VERSION);
$VERSION = qw($Revision: 2.3.3 $) [1];

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # get needed objects
    for (qw(ConfigObject LogObject DBObject TicketObject LayoutObject UserID UserObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }
    $Self->{SearchProfileObject} = Kernel::System::SearchProfile->new(%Param);
    return $Self;
}

sub Run {
    my ( $Self, %Param ) = @_;

    my %Return = ();
    return %Return unless $Param{Type} eq 'Ticket';

    # get user data
    my %User = $Self->{UserObject}->GetUserData(
        UserID => $Self->{UserID},
        Cached => 1,
    );

    # get search profiles string
    my %Profiles = $Self->{SearchProfileObject}->SearchProfileList(
        Base      => 'TicketSearch',
        UserLogin => $User{UserLogin},
      );

    my $dialog_panel = '';
    for ( sort keys %Profiles ) {
        $dialog_panel .= <<_;
                <input type="radio" name="Profile" ondblclick="dialog_shortcut(this,true)" value="$_" />
                <b onclick="dialog_shortcut(this,false);" ondblclick="dialog_shortcut(this,true);">$_</b><br />
_
    }

    $Return{'0000302'} = {
        AccessKey   => 't',
        Block       => 'Item',
        Description => 'Search-Templates',
        Image       => 'import.png',
        Link        => 'Action=AgentTicketNorisSearch',
        LinkOption  => 'onclick="javascript: search_action(this); return false;"',
        Name        => $Self->{LayoutObject}->{LanguageObject}->Get('Search-Templates'),
        ExtraBlock  => 'ItemDPanel',
        ExtraData   => { dialog_panel => $dialog_panel },
    };

    return %Return;
}

1;
