# --
# Kernel/Output/HTML/LayoutSimilarTicketObject.pm - provides generic HTML output for Similar Tickets
# Copyright (C) 2009 noris network AG, http://www.noris.net/
# --
# $Id$
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl-2.0.txt.
# --

package Kernel::Output::HTML::LayoutSimilarTicketObject;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 0.0.1 $) [1];

=item SimilarTicketTableCreate()

creates a table which contains link to similar Tickets

    my $String = $LayoutObject->SimilarTicketTableCreate(
        TicketID => $TicketID, # '1234567890'
        QueueID  => $QueueID,  # '12' or ['1', '2']
        Title    => $Title,    # 'My Ticket Title'
    );

=cut

sub SimilarTicketTableCreate {
    my ( $Self, %Param ) = @_;

    # check needed objects
    for (qw(TicketObject LayoutObject LogObject ConfigObject)) {
        if ( !$Self->{$_} ) {
            $Self->{LayoutObject}->FatalError( Message => "Got no $_!" );
        }
    }

    # check needed stuff
    for (qw(TicketID QueueID Title)) {
        if ( !$Param{$_} ) {
            $Self->{LogObject}->Log(
                Priority => 'error',
                Message  => "Need $_!",
            );
            return;
        }
    }

    my $MaxTickets = $Self->{ConfigObject}->Get('Ticket::Frontend::MaxSimilarTickets');

    # get Tickets
    my @SimilarTickets = $Self->{TicketObject}->TicketSearch(
        Result     => 'ARRAY',
        Title      => $Param{Title},
        QueueIDs   => [ $Param{QueueID} ],
        Limit      => $MaxTickets + 2,
        SortBy     => 'Age',
        OrderBy    => 'Down',
        UserID     => 1,
        Permission => 'ro',
    );
    if ( @SimilarTickets < 2 ) { return ''; }

    my $SearchURL =
        '?Action=AgentTicketNorisSearch'
      . '&Subaction=Search'
      . '&ShowTicketAge=1'
      . '&ShowTicketCustomerID=1'
      . '&ShowTicketOwner=1'
      . '&ShowTicketPriority=1'
      . '&ShowTicketState=1'
      . '&Title='
      . $Self->{LayoutObject}->LinkEncode( $Param{Title} );

    # define needed Objects
    my $LayoutObject = Kernel::Output::HTML::Layout->new( %{$Self} );
    $LayoutObject->Block(
        Name => 'TableSimilarTickets',
        Data => {
            TicketID  => "#" . $Param{TicketID},
            Title     => $Param{Title},
            SearchURL => $SearchURL,
        }
    );

    my $Count = 0;
    for my $TID (@SimilarTickets) {
        next if ( $TID == $Param{TicketID} );
        if ( $Count >= $MaxTickets ) {
            $LayoutObject->Block(
                Name => 'TableMoreSimilarTickets',
                Data => { SearchURL => $SearchURL, },
            );
            last;
        }
        $Count++;
        my %Ticket = $Self->{TicketObject}->TicketGet( TicketID => $TID );
        $LayoutObject->Block(
            Name => 'TableSimilarTicketRow',
            Data => {
                CSSStyle => (
                    $Ticket{StateType} eq 'closed'
                    ? 'style="text-decoration:line-through"'
                    : ''
                ),
                TicketID   => $TID,
                CreateDate => $Self->{LayoutObject}->CustomerAgeHumanReadable(
                    Age   => 0 - $Ticket{Age},
                    Space => ' '
                ),
                Owner        => $Ticket{Owner},
                TicketNumber => $Ticket{TicketNumber},
            }
        );
    }

    return $LayoutObject->Output(
        TemplateFile => 'SimilarTickets',
    );
}

1;
