use strict;
use warnings;

package Kernel::Noris::kundebunt;

use Encode qw(decode encode);
use JSON qw(decode_json);
use LWP::UserAgent ();
use HTTP::Request::Common qw(POST);



=item http_client()

Interface zu den kundebunt-Webdiensten

http_client(
    ConfigObject => $Self->{ConfigObject},
    Method => 'customer-id',
    Params => [
        search => '*',
    ]
)

Gibt eine Referenz auf den data-Teil des Ergebnisses. Wenn der Zugriff fehlschlägt, wird
die() aufgerufen.

=cut


sub kundebunt_client {
    my %Param = @_;
    my $ConfigObject = $Param{ConfigObject};
    my $Method = $Param{Method};
    my $PostParams = $Param{Params};

    my $WebServiceConfig = $ConfigObject->Get("CustomerUser")->{Params}->{WebService};
    my $response = LWP::UserAgent->new->request(
        POST "$WebServiceConfig->{Url}$Method/",
            [ map {encode('utf8',$_)} @$PostParams,
              password => $WebServiceConfig->{Password} ] );
    die "Error sending query for @_ to kundebunt: "
      . $response->status_line . "\n"
      unless $response->is_success;

    my $content = $response->content;

    #10084478: decode_json does the Work for us. $content should be UTF-8
    #if ( defined ( my $content_type = $response->header('Content-Type') ) ) {
    #    $content_type =~ /\bcharset=(.+)/i
    #      and $content = decode( $1, $content );
    #}
    decode_json($content)->{data};
}

1;
