use strict;
use warnings;
use utf8;

package Kernel::Noris::TicketServer::ResultBuffer;
use Data::Dump qw(pp);

use Moose;

# status: init -> writing -> full -> reading

my $all_requests = {};
my $next_request_id = 1;
my $BLOCK_SIZE = 100;

has 'buffer_id' => (is => 'ro', isa => 'Int');
has 'fields' => (is => 'rw', isa => 'ArrayRef', required => 1);
has 'status' => (is => 'ro', isa => 'String');
has 'cursor' => (is => 'ro', isa => 'Int', default => sub { return 0; });
has 'results' => (is => 'ro', isa => 'HashRef');
has 'count' => (is => 'ro', isa => 'Int');
# has 'otrs' => (is => 'ro', isa => 'HashRef');


sub BUILD {
    my ($self, $param) = @_;
    $self->{status} = 'init';
    $self->{cursor} = 0;
    $self->{results} = [];
    $self->{buffer_id} = $next_request_id ++;
    $all_requests->{$self->{buffer_id}} = $self;
}

sub get_buffer {
    my ($buffer_id) = @_;
    return $all_requests->{$buffer_id};
}

sub delete_buffer {
    my ($buffer_id) = @_;
    delete $all_requests->{$buffer_id};
}

sub set_results {
    my ($self, $data) = @_;
    die "result buffer not writeable." unless $self->status eq 'init';
    $self->{status} = 'writing';
    $self->{results} = $data;
    $self->{count} = @$data;
    $self->{status} = 'full';
}

sub read_block {
    my ($self) = @_;
    my $cursor;
    if ($self->{status} eq 'full') {
        $cursor = 0;
        $self->{status} = 'reading';
    }
    elsif ($self->{status} eq 'reading') {
        $cursor = $self->{cursor};
    }
    else {
        die "result buffer not ready for reading."
    }
    
    my $buf_count = $self->{count};
    my $next_cursor = $cursor + $BLOCK_SIZE;
    if ($next_cursor > $buf_count) {
        $next_cursor = $buf_count;
    }
    $self->{cursor} = $next_cursor;
    return [ @{$self->{results}}[$cursor..$next_cursor-1] ];
}

sub end_reached {
    my ($self) = @_;
    my $cursor;
    if ($self->{status} eq 'full') {
        $cursor = 0;
        $self->{status} = 'reading';
    }
    elsif ($self->{status} eq 'reading') {
        $cursor = $self->{cursor};
    }
    else {
        die "result buffer not ready for reading."
    }
    my $buf_count = $self->{count};
    return $cursor >= $self->{count};
}


1;
