use strict;
use warnings;
use utf8;

package Kernel::Noris::TicketServer::Request::User;

use Log::Log4perl qw(get_logger);
use Moose;

extends 'Kernel::Noris::TicketServer::Request';

sub respond {
    my ($self) = @_;
    my $connection = $self->connection;
    my $new_user_name = $self->param->[0];
    die "No permission to change user to $new_user_name\n" 
        unless $self->connection->is_allowed_to_change_user($new_user_name);
    my $user_id = $connection->get_user_id($new_user_name);
    die "User lookup for '" . $new_user_name . "' failed\n"
        unless defined $user_id;
    $connection->eff_user_id($user_id);
    return "OK\n";
}

sub check_allowed {
    # always allowed. respond() will check whether the change
    # to the new user is allowed.
    my ($self) = @_;
    return 1;
}

1;
