use strict;
use warnings;
use utf8;

package Kernel::Noris::TicketServer::Request::SelectTicket;

use Moose;
use Kernel::Noris::TicketServer::ResultBuffer;
use Kernel::Noris::TicketServer::Conversions;
use Log::Log4perl qw(get_logger);
use Data::Dump qw(pp);
use List::Util qw(first);

extends 'Kernel::Noris::TicketServer::Request';
has 'result_buffer' => (is => 'ro', isa => 'Object');

sub is_data_required {
    return 1;
}

sub respond {
    my ($self) = @_;
    my $user_id = $self->connection->eff_user_id;
    die "select_ticket request requires a valid user\n" unless defined $user_id;
    my @fields = @Kernel::Noris::TicketServer::Conversions::Fields{@{$self->param}};
    for my $i (0..@fields-1) {
        die "No such field: " . $self->param->[$i] . "\n" unless defined $fields[$i];
    }
    $self->{result_buffer} = Kernel::Noris::TicketServer::ResultBuffer->new(
        fields => \@fields);
    return $self->{result_buffer}->buffer_id() . "\n";
}

sub background_process {
    my ($self) = @_;
    my $logger = get_logger(__PACKAGE__);
    my $connection = $self->connection;
    die "select_ticket request requires a valid user\n" unless defined $connection->eff_user_id;
    my @wrong = grep( ! exists $Kernel::Noris::TicketServer::Conversions::Fields{$_},
                      keys %{$self->{req_data}});
    die "undefined field in search specification: @wrong\n" if @wrong;
    my @search_fields = @Kernel::Noris::TicketServer::Conversions::Fields{
                            keys %{$self->{req_data}}};
    my %filter = ();
    for my $field (@search_fields) {
        my %field_filter = $field->build_otrs_filter(
            $connection->otrs,
            $self->{req_data}->{$field->api});
        for my $crit (keys %field_filter) {
            if (exists $filter{$crit}) {
                if ($crit eq 'TicketNumber') {
                    $logger->debug("combining multiple TicketNumber search criteria: "
                        . pp($filter{TicketNumber}, $field_filter{TicketNumber}))
                        if $logger->is_debug;
                    my %tn1 = map +($_, ''), @{$filter{TicketNumber}};
                    $filter{TicketNumber} = [grep exists $tn1{$_}, @{$field_filter{TicketNumber}}];
                    $logger->debug("combined result: " . pp($filter{TicketNumber}))
                        if $logger->is_debug;
                }
                else {
                    die "Program error: More than one field referred to the same OTRS search field '$crit'";
                }
            }
            else {
                $filter{$crit} = $field_filter{$crit};
            }
        }
    }

    my $buffer = $self->{result_buffer};
    $logger->debug("eff-user: " . $connection->eff_user_id . ", otrs-filter: " . pp(\%filter)) 
        if $logger->is_debug();
    if (! defined first {ref $_ eq 'ARRAY' && !@$_} values %filter) {
        my @results = $connection->otrs->{ticket}->TicketSearch(
                Result => 'ARRAY',
                UserID => $connection->eff_user_id,
                %filter,
            );
        $logger->debug("got " . scalar @results . " matches") if $logger->is_debug();
        $buffer->set_results(\@results);
    } else {
        $logger->debug("No results (at least one search criterium is an empty list)");
        $buffer->set_results([]);
    }
}


1;
