use strict;
use warnings;
use utf8;

package Kernel::Noris::TicketServer::Request::Fetch;

use Moose;
use JSON qw(to_json);
use Data::Dump qw(pp);

extends 'Kernel::Noris::TicketServer::Request';

sub respond {
    my ($self) = @_;
    my $connection = $self->connection;
    die "fetch request requires a valid user\n" unless defined $connection->eff_user_id;
    my $buffer_id = $self-> {param}->[0];
    my $user_id = $connection->eff_user_id;
    my $buffer = Kernel::Noris::TicketServer::ResultBuffer::get_buffer($buffer_id);
    my @result = ();
    die "no such buffer\n" unless defined $buffer;
    die "buffer not ready\n" unless $buffer->status eq 'full' || $buffer->status eq 'reading';
    my $fields = $buffer->fields;
    
    my $ids = $buffer->read_block();
    for my $ticket_id (@$ids) {
        my %ticket = $connection->otrs->{ticket}->TicketGet(
                TicketID => $ticket_id,
                UserID => $connection->eff_user_id,
            );
        push @result, [map $_->get_from_otrs_data($connection->otrs, \%ticket, $buffer), @$fields];
    }
    my $end_reached = $buffer->end_reached();
    return 
        ($end_reached ? "LAST\n" : "MORE\n")
        . encode(\@result)
        . "\n\n";
}

sub encode {
    my ($data) = @_;
    return to_json($data);
}


1;
