use strict;
use warnings;
use utf8;

package Kernel::Noris::TicketServer::Request::Count;

use Moose;
extends 'Kernel::Noris::TicketServer::Request';

sub respond {
    my ($self) = @_;
    my $buffer_id = $self-> {param}->[0];
    my $buffer = Kernel::Noris::TicketServer::ResultBuffer::get_buffer($buffer_id);
    die "no such buffer\n" unless defined $buffer;
    die "buffer not ready\n" unless $buffer->status eq 'full' || $buffer->status eq 'reading';
    
    return $buffer->count() . "\n";
}


1;
