use strict;
use warnings;
use utf8;

package Kernel::Noris::TicketServer::Request::Close;

use Moose;
use Data::Dump qw(pp);
use Kernel::Noris::TicketServer::ResultBuffer;

extends 'Kernel::Noris::TicketServer::Request';

sub respond {
    my ($self) = @_;
    my $buffer_id = $self-> {param}->[0];
    die "buffer does not exist in close operation\n"
        unless defined Kernel::Noris::TicketServer::ResultBuffer::get_buffer($buffer_id);
    die "buffer id missing in close operation\n" unless defined $buffer_id;
    Kernel::Noris::TicketServer::ResultBuffer::delete_buffer($buffer_id);
    return "OK\n";
}



1;
