use strict;
use warnings;
use utf8;

package Kernel::Noris::TicketServer::Request;

use Moose;
use Kernel::Noris::TicketServer::Request::Ping;
use Kernel::Noris::TicketServer::Request::SelectTicket;
use Kernel::Noris::TicketServer::Request::Count;
use Kernel::Noris::TicketServer::Request::Fetch;
use Kernel::Noris::TicketServer::Request::Close;
use Kernel::Noris::TicketServer::Request::Quit;
use Kernel::Noris::TicketServer::Request::User;
use Kernel::Noris::TicketServer::Request::FollowTicket;

use Log::Log4perl qw(get_logger);

my %type_map = (
    ping => 'Kernel::Noris::TicketServer::Request::Ping',
    select_ticket => 'Kernel::Noris::TicketServer::Request::SelectTicket',
    count => 'Kernel::Noris::TicketServer::Request::Count',
    fetch => 'Kernel::Noris::TicketServer::Request::Fetch',
    close => 'Kernel::Noris::TicketServer::Request::Close',
    quit => 'Kernel::Noris::TicketServer::Request::Quit',
    user => 'Kernel::Noris::TicketServer::Request::User',
    follow_ticket => 'Kernel::Noris::TicketServer::Request::FollowTicket',
);

has 'req_data' => (is => 'rw', isa => 'HashRef');
has 'param' => (is => 'ro', isa => 'ArrayRef');
has 'connection' => (is => 'ro', isa => 'Kernel::Noris::TicketServer::Connection', required => 1);
    
sub create {
    my ($connection, $type, @param) = @_;
    return undef unless defined $type;
    my $package = $type_map{$type};
    if (defined $package) {
        return $package->new(param => \@param, connection => $connection);
    }
    else {
        return undef;
    }
}

sub is_data_required {
    my ($self) = @_;
    return 0;
}

sub is_quit {
    my ($self) = @_;
    return 0;
}

sub background_process {
    my ($self) = @_;
    return;
}

sub check_allowed {
    my ($self) = @_;
    
    my $connection = $self->connection;
    
    die "No access for user " 
        . $self->connection->real_user_name 
        . " - You need to use the 'user' command to set a different effective user\n"
        unless defined $connection->eff_user_id;
}


1;
