use utf8;
use strict;
use warnings;


package Kernel::Noris::TicketServer::Conversions::VirtualField;

use Moose;

has 'api' => (is => 'ro', isa => 'Str', required => 1);
has 'fn' => (is => 'ro', isa => 'CodeRef', required => 1);

=begin testing

use lib '/home/mir/src/otrs';
use Kernel::Noris::TicketServer::Conversions::VirtualField;
# use Kernel::Noris::TicketServer::Connection;
# use Kernel::Noris::TicketServer::Conversions::StringField;
# 
# my $connection = Kernel::Noris::TicketServer::Connection->new(real_user_name => 'otrs-sys');
# my $otrs_obj = $connection->otrs;

my $field = Kernel::Noris::TicketServer::Conversions::VirtualField->new(
    api => 'test', 
    fn => sub { my ($data) = @_; return "Test-$data->{TicketNumber}"; },
);
is $field->get_from_otrs_data( undef, {TicketNumber => 42 }), "Test-42";

=end testing

=cut

sub build_otrs_filter {
    my ($self) = @_;
    die "Cannot search for virtual field $self->{api}\n";
}
        
sub get_from_otrs_data
{
    my ($self, $otrs, $data) = @_;
    return $self->fn->($data, $otrs);
}


1;
