use utf8;
use strict;
use warnings;

package Kernel::Noris::TicketServer::Conversions::StringField;

use Moose;

use Data::Dump qw(pp);

has 'api' => (is => 'ro', isa => 'Str', required => 1);
has 'otrs' => (is => 'ro', isa => 'Str', required => 1);

=begin testing

use lib '/home/mir/src/otrs';
use Kernel::Noris::TicketServer::Connection;
use Kernel::Noris::TicketServer::Conversions::StringField;

my $connection = Kernel::Noris::TicketServer::Connection->new(
    real_user_name => 'otrs-sys',
    remote_host => 'localhost');
my $otrs_obj = $connection->otrs;
my $field = Kernel::Noris::TicketServer::Conversions::StringField->new(
    api => 'title', 
    otrs => 'Title');

is_deeply [$field->build_otrs_filter($otrs_obj, 'obrifuskator % defekt')], 
          [Title => ['obrifuskator % defekt']];
is_deeply [$field->build_otrs_filter($otrs_obj, ['in', 'obri %', 'untri _'])],
          [Title => ['obri %', 'untri _']];
is_deeply [$field->build_otrs_filter($otrs_obj, ['like', 'abra%dabra'])],
          [Title => 'abra%dabra'];


=end testing

=cut

sub build_otrs_filter {
    my ($self, $otrs_obj, $data) = @_;
    if (ref $data eq 'ARRAY') {
        my ($op, @values) = @$data;
        if ($op eq 'in') {
            return ($self->otrs, \@values);
        }
        elsif ($op eq 'like') {
            die "only one value allowed for LIKE operator for field $self->{api}\n"
                unless @values == 1;
            return ($self->otrs, $values[0]);
        }
        else {
            die "cannot handle operator \"$op\" for field $self->{api}\n";
        }
    }
    else {
        die "not a list ref for field $self->{api}\n" if ref $data;
        return ($self->otrs, [$data]);
    }
}
        
=begin testing

my $field = Kernel::Noris::TicketServer::Conversions::StringField->new(
    api => 'title', 
    otrs => 'Title');
my $data = { Title => 'Schneradikon korrodiert' };

is $field->get_from_otrs_data(undef, $data), 'Schneradikon korrodiert';

=end testing

=cut
  

sub get_from_otrs_data
{
    my ($self, $otrs, $data) = @_;
    return $data->{$self->otrs};
}




1;
