use utf8;
use strict;
use warnings;

package Kernel::Noris::TicketServer::Conversions::StatusField;

use Moose;

use Data::Dump qw(pp);

extends 'Kernel::Noris::TicketServer::Conversions::ChoiceField';

my %StatusToTypeMap = (
    open => ['new', 'open', 'seen', 'pending over'],
    stalled => [ 'pending auto', 'pending reminder', 'hidden' ],
    resolved => [ 'closed' ],
    merged => [ 'merged' ],
    dead => [ 'removed' ],
);

my %TypeToStatusMap = ();

for my $key (keys %StatusToTypeMap) {
    for my $typ (@{$StatusToTypeMap{$key}}) {
        $TypeToStatusMap{$typ} = $key;
    }
}
    

override 'all_choices' => sub {
    my ($self, $otrs_obj) = @_;
    return [keys %StatusToTypeMap];
};

override 'convert_search_values' => sub {
    my ($self, $value_list) = @_;
    my @wrong = grep (! exists $StatusToTypeMap{$_}, @$value_list);
    die "Unknown value for $self->{api}: @wrong\n" if @wrong;
    return [map @{$StatusToTypeMap{$_}}, @$value_list];
};


override 'get_from_otrs_data' => sub {
    my ($self, $otrs, $data) = @_;
    return $TypeToStatusMap{$data->{$self->otrs}};
};


1;
