package Kernel::Noris::TicketServer::Conversions::QueueField;

use Moose;

use Data::Dump qw(pp);

extends 'Kernel::Noris::TicketServer::Conversions::ChoiceField';

override 'value_to_regex' => sub {
    my ($self, $op, $value) = @_;
    my $s = $self->_value_to_regex($op, $value);
    $s =~ s/\\:\\:$/(|::.*)/;
    $s = "^$s\$";
    return $s;
};

override 'all_choices' => sub {
    my ($self, $otrs_obj) = @_;
    return $self->{_choices} if exists $self->{_choices};
    my %choices = $otrs_obj->{queue}->GetAllQueues();
    $self->{_choices} = [values %choices];
    return $self->{_choices};
};



1;
