package Kernel::Noris::TicketServer::Conversions::PriorityField;

use Moose;

extends 'Kernel::Noris::TicketServer::Conversions::NumericChoiceField';

=begin testing

use lib '/home/mir/src/otrs';
use Kernel::Noris::TicketServer::Connection;
use Kernel::Noris::TicketServer::Conversions::PriorityField;

my $connection = Kernel::Noris::TicketServer::Connection->new(
    real_user_name => 'otrs-sys',
    remote_host => 'localhost');
my $otrs_obj = $connection->otrs;

my $field = Kernel::Noris::TicketServer::Conversions::PriorityField->new(
    api => 'priority',
    otrs => 'Priority',
    otrs_search => 'Priorities',);

is_deeply [$field->build_otrs_filter($otrs_obj, 8)],
          [Priorities => ["08"]];
is_deeply [$field->build_otrs_filter($otrs_obj, ['=', 2,3,5,7,11])],
          [Priorities => [qw(02 03 05 07 11)]];
is_deeply [$field->build_otrs_filter($otrs_obj, ['<', 4])],
          [Priorities => [qw(00 01 02 03)]];
is_deeply [$field->build_otrs_filter($otrs_obj, ['<=', 4])],
          [Priorities => [qw(00 01 02 03 04)]];
is_deeply [$field->build_otrs_filter($otrs_obj, ['>', 95])],
          [Priorities => [96,97,98,99]];
is_deeply [$field->build_otrs_filter($otrs_obj, ['>=', 95])],
          [Priorities => [95,96,97,98,99]];
is_deeply [$field->build_otrs_filter($otrs_obj, ['range', 18, 23])],
          [Priorities => [18,19,20,21,22,23]];

=end testing

=cut

override 'compute_range' => sub {
    my ($self, $lower, $upper) = @_;
    $lower = "00" unless defined $lower;
    $upper = "99" unless defined $upper;
    return [$lower..$upper];
};

override 'convert_search_values' => sub {
    my ($self, $value_list) = @_;
    return [map sprintf("%02d", $_), @$value_list];
};

1;
