package Kernel::Noris::TicketServer::Conversions::OwnerField;

use Moose;

use Data::Dump qw(pp);

extends 'Kernel::Noris::TicketServer::Conversions::StringField';

# has 'api' => (is => 'ro', isa => 'Str', required => 1);
# has 'otrs' => (is => 'ro', isa => 'Str', required => 1);
has 'otrs_search' => (is => 'ro', isa => 'Str', required => 1);

override 'build_otrs_filter' => sub {
    my ($self, $otrs_obj, $data) = @_;
    if (! ref $data) {
        $data = ["in", $data];
    }
    die "not a list ref for field $self->{api}" if ref $data ne 'ARRAY';
    my ($op, @values) = @$data;
    if ($op eq 'in') {
        return ($self->otrs_search, $self->convert_search_values($otrs_obj, \@values));
    }
    else {
        die "cannot handle operator \"$op\" for field $self->{api}\n";
    }
};

sub convert_search_values {
    my ($self, $otrs_obj, $value_list) = @_; 
    my $user_obj = $otrs_obj->{user};
    return [map $user_obj->UserLookup(UserLogin => $_), @$value_list];
}

sub get_from_otrs_data
{
    my ($self, $otrs, $data) = @_;
    if ($data->{$self->otrs} eq 'otrs-sys') {
        return undef;
    }
    else {
        return $data->{$self->otrs};
    }
}


1;
