use utf8;
use strict;
use warnings;

package Kernel::Noris::TicketServer::Conversions::OriginField;

use Moose;

use Data::Dump qw(pp);

has 'api' => (is => 'ro', isa => 'Str', required => 1);


sub build_otrs_filter {
    my ($self) = @_;
    die "field '$self->{api}' is not searchable\n";
}

sub get_from_otrs_data
{
    my ($self, $otrs, $data, $buffer) = @_;
    die "'$self->{api}' is only supported within follow-by result sets\n"
        unless exists $buffer->{origin};
    my @origin_ids = @${$buffer->origin->{$data->{TicketID}}};
    return [map $otrs->{ticket}->TicketNumberLookup(
                    TicketID => $_,
                    UserID   => 1,
                    ),
                @origin_ids];
}

1;
