package Kernel::Noris::TicketServer::Conversions::NumericChoiceField;

use Moose;
use Data::Dump qw(pp);

extends 'Kernel::Noris::TicketServer::Conversions::ChoiceField';

# Abstrakte Oberklasse, daher keine direkte Tests der Methoden.

override 'build_otrs_filter' => sub {
    my ($self, $otrs_obj, $data) = @_;
    my ($op, @values, $hits);
    if (ref $data ne 'ARRAY') {
        $op = '=';
        @values = ($data);
    }
    else {
        ($op, @values) = @$data;
    }
    die "too many operands for $op in field " . $self->{api} . "\n"
        if $op =~ /^(<=?|>=?)$/ && @values > 1 || $op ne '=' && @values > 2;
    if ($op eq '=') {
        $hits = \@values;
    }
    else {
        my @range;
        my $value = $values[0];
        if ($op eq '<') {
            @range = (undef, $value-1);
        }
        elsif ($op eq '<=') {
            @range = (undef, $value);
        }
        elsif ($op eq '>=') {
            @range = ($value,undef);
        }
        elsif ($op eq '>') {
            @range = ($value+1,undef);
        }
        elsif ($op eq 'range') {
            @range = @values;
        }
        else {
            die "cannot handle operator \"$op\" for field $self->{api}\n";
        }
        $hits = $self->compute_range(@range);
    }
    return ($self->otrs_search, $self->convert_search_values($hits));
};

sub compute_range {
    my ($self, $lower, $upper) = @_;
    my $choices = $self->all_choices();
    return [grep (((! defined $lower || $lower <= $_)
                  && (! defined $upper || $_ <= $upper)), @$choices)];
}


1;
