use utf8;
use strict;
use warnings;

package Kernel::Noris::TicketServer::Conversions::LockField;

use Moose;

use Data::Dump qw(pp);

extends 'Kernel::Noris::TicketServer::Conversions::ChoiceField';

=begin testing

use lib '/home/mir/src/otrs';
use Kernel::Noris::TicketServer::Connection;
use Kernel::Noris::TicketServer::Conversions::LockField;

my $connection = Kernel::Noris::TicketServer::Connection->new(
    real_user_name => 'otrs-sys',
    remote_host => 'localhost');
my $otrs_obj = $connection->otrs;

my $field = Kernel::Noris::TicketServer::Conversions::LockField->new(
        api => 'locked',
        otrs => 'Lock',
        otrs_search => 'Locks',);

is_deeply [$field->build_otrs_filter($otrs_obj, 'lock')],
          [ Locks => ["lock"]];
is_deeply [$field->build_otrs_filter($otrs_obj, [not_in => 'lock'])],
          [ Locks => ["unlock", "tmp_lock"]];

=end testing

=cut


override 'all_choices' => sub {
    my ($self, $otrs_obj) = @_;
    my %IdToTypeMap = $otrs_obj->{lock}->LockList( UserID => 1);
    return [values %IdToTypeMap];
};


1;
