use utf8;
use strict;
use warnings;

package Kernel::Noris::TicketServer::Conversions::EstEffortField;

use Moose;

extends 'Kernel::Noris::TicketServer::Conversions::StringField';

# has 'api' => (is => 'ro', isa => 'Str', required => 1);
# has 'otrs' => (is => 'ro', isa => 'Str', required => 1);
# has 'otrs_search' => (is => 'ro', isa => 'Str', required => 1);

# Wenn keine Planzeit gesetzt ist, steht in OTRS ein leerer String.
# Das muß als undef übergeben werden.
# Siehe #10059207

=begin testing

use lib '/home/mir/src/otrs';
use Kernel::Noris::TicketServer::Connection;
use Kernel::Noris::TicketServer::Conversions::EstEffortField;

my $connection = Kernel::Noris::TicketServer::Connection->new(
    real_user_name => 'otrs-sys',
    remote_host => 'localhost');
my $otrs_obj = $connection->otrs;
my $field = Kernel::Noris::TicketServer::Conversions::EstEffortField->new(
    api => 'title',
    otrs => 'Title');

is_deeply [$field->build_otrs_filter($otrs_obj, 'obrifuskator % defekt')],
          [Title => ['obrifuskator % defekt']];
is_deeply [$field->build_otrs_filter($otrs_obj, ['in', 2, 3, 5, 7, 11])],
          [Title => [qw(2 3 5 7 11)]];
is_deeply [$field->build_otrs_filter($otrs_obj, ['in', '0', undef, ''])],
          [Title => ['0', '', '']];

=end testing

=cut

override 'build_otrs_filter' => sub {
    my ($self, $otrs_obj, $data) = @_;
    $data = ["in", $data] unless ref $data;
    $data = [map defined $_ ? $_ : "", @$data];
    return $self->SUPER::build_otrs_filter($otrs_obj, $data);
};


=begin testing

my $field = Kernel::Noris::TicketServer::Conversions::EstEffortField->new(
    api => 'title',
    otrs => 'Title');
my $data = { Title => '' };

is $field->get_from_otrs_data(undef, { Title => '3.14159265' }), '3.14159265';
is $field->get_from_otrs_data(undef, { Title => undef }), undef;
is $field->get_from_otrs_data(undef, { Title => '' }), undef;
is $field->get_from_otrs_data(undef, { Title => '0' }), undef;
=end testing

=cut

sub get_from_otrs_data
{
    my ($self, $otrs, $data) = @_;
    return $data->{$self->otrs} || undef;
}


1;
