package Kernel::Noris::TicketServer::Conversions::EpochDateTimeField;

use Moose;
use DateTime;

extends 'Kernel::Noris::TicketServer::Conversions::DateTimeField';

override 'get_from_otrs_data' => sub
{
    my ($self, $otrs, $data) = @_;
    my $epoch = $data->{$self->otrs};
    return undef unless defined $epoch;
    my $dt = DateTime->from_epoch( epoch => $epoch);
    return Kernel::Noris::TicketServer::Conversions::DateTimeField::DateTime_to_otrs($dt);
};

1;
