use utf8;
use strict;
use warnings;


package Kernel::Noris::TicketServer::Conversions::EmailField;

use Moose;

has 'api' => (is => 'ro', isa => 'Str', required => 1);

=begin testing

use lib '/home/mir/src/otrs';
use Kernel::Noris::TicketServer::Conversions::EmailField;
use Kernel::Noris::TicketServer::Connection;
my $connection = Kernel::Noris::TicketServer::Connection->new(
    real_user_name => 'otrs-sys',
    remote_host => 'localhost');
my $otrs_obj = $connection->otrs;

my $field = Kernel::Noris::TicketServer::Conversions::EmailField->new(
    api => 'ticket_email',
);
like $field->get_from_otrs_data( $otrs_obj, {TicketNumber => 42 }),
     qr'^42@';

=end testing

=cut

sub build_otrs_filter {
    my ($self) = @_;
    die "Cannot search for field $self->{api}\n";
}

sub get_from_otrs_data
{
    my ($self, $otrs, $data) = @_;
    return $otrs->{ticket}->TicketEnvelopeSender(
        TicketNumber => $data->{TicketNumber}
    );
}


1;
