package Kernel::Noris::TicketServer::Conversions::DateTimeField;

use Moose;

use Data::Dump qw(pp);
use DateTime;
use DateTime::TimeZone;

has 'api' => (is => 'ro', isa => 'Str', required => 1);
has 'otrs' => (is => 'ro', isa => 'Str', required => 1);
has 'otrs_search' => (is => 'ro', isa => 'Str', required => 1);

=begin testing

use lib '/home/mir/src/otrs';
use Kernel::Noris::TicketServer::Connection;
use Kernel::Noris::TicketServer::Conversions::DateTimeField;

my $connection = Kernel::Noris::TicketServer::Connection->new(
    real_user_name => 'otrs-sys',
    remote_host => 'localhost');
my $otrs_obj = $connection->otrs;

my $field = Kernel::Noris::TicketServer::Conversions::DateTimeField->new(
    api => 'created', 
    otrs => 'Created',
    otrs_search => 'TicketCreateTime',);

is_deeply [$field->build_otrs_filter($otrs_obj, '2009-01-01 10:00:00')],
          [TicketCreateTimeNewerDate => '2009-01-01 10:00:00',
           TicketCreateTimeOlderDate => '2009-01-01 10:00:00'];
is_deeply [$field->build_otrs_filter($otrs_obj, [ '=', '2009-01-01 10:00:00'])],
          [TicketCreateTimeNewerDate => '2009-01-01 10:00:00',
           TicketCreateTimeOlderDate => '2009-01-01 10:00:00'];
is_deeply [$field->build_otrs_filter($otrs_obj, [ '<', '2009-01-01 10:00:00'])],
          [TicketCreateTimeOlderDate => '2009-01-01 09:59:59'];
is_deeply [$field->build_otrs_filter($otrs_obj, [ '<=', '2009-01-01 10:00:00'])],
          [TicketCreateTimeOlderDate => '2009-01-01 10:00:00'];
is_deeply [$field->build_otrs_filter($otrs_obj, [ '>=', '2009-01-01 10:00:00'])],
          [TicketCreateTimeNewerDate => '2009-01-01 10:00:00'];
is_deeply [$field->build_otrs_filter($otrs_obj, [ '>', '2009-01-01 10:00:00'])],
          [TicketCreateTimeNewerDate => '2009-01-01 10:00:01'];
is_deeply [$field->build_otrs_filter($otrs_obj, [ 'range', '2009-01-01 10:00:00', '2009-01-01 12:00:00'])],
          [TicketCreateTimeNewerDate => '2009-01-01 10:00:00',
           TicketCreateTimeOlderDate => '2009-01-01 12:00:00'];
is_deeply [$field->build_otrs_filter($otrs_obj, undef)],
          [TicketCreateTimeMissing => 1];

=end testing

=cut

sub build_otrs_filter {
    my ($self, $otrs_obj, $data) = @_;
    my ($op, @values);
    if (! ref $data) {
        $op = '=';
        @values = ($data);
    }
    elsif (ref $data eq 'ARRAY') {
        ($op, @values) = @$data;
    }
    else {
        die "not a list ref for field $self->{api}" if ref $data;
    }
    if ($op ne 'range' && @values > 1) {
        die "only one value allowed for $op operator for field $self->{api}\n";
    }
    @values = map wire_to_DateTime($_), @values;
    my $value = $values[0];

    # Sonderfall: Abfrage auf undef
    if (($op eq 'is'  || $op eq '=') && ! defined $value) {
        return ( $self->otrs_search . 'Missing', 1 );
    }

    my @range;
    
    if ($op eq 'is' || $op eq '=') {
        @range = ($value, $value);
    }
    elsif ($op eq '<') {
        $value->subtract(seconds => 1);
        @range = (undef, $value);
    }
    elsif ($op eq '<=') {
        @range = (undef, $value);
    }
    elsif ($op eq '>=') {
        @range = ($value,undef);
    }
    elsif ($op eq '>') {
        $value->add(seconds => 1);
        @range = ($value,undef);
    }
    elsif ($op eq 'range') {
        @range = @values;
    }
    
    my @result;
    
    if (defined $range[0]) {
        @result = ( $self->otrs_search . 'NewerDate', DateTime_to_otrs($range[0]) );
    }
    if (defined $range [1]) {
        push @result, ( $self->otrs_search . 'OlderDate', DateTime_to_otrs($range[1]) );
    }
    return @result;
}

sub get_from_otrs_data
{
    my ($self, $otrs, $data) = @_;
    return $data->{$self->otrs};
}

my $_tz_local = DateTime::TimeZone->new( name => 'local' );

sub wire_to_DateTime {
    my ($isodate) = @_;
    return undef
        unless defined $isodate
            && $isodate =~ /^(....)-(..)-(..) (..):(..)(?::(..))?$/;
    my %parsed = (
        year => $1,
        month => $2,
        day => $3,
        hour => $4,
        minute => $5,
        second => $6 || 0,
    );
    return DateTime->new(%parsed, time_zone => $_tz_local);
}

sub DateTime_to_otrs {
    my ($dt) = @_;
    return  $dt->ymd('-') . ' ' . $dt->hms(':');
}


1;
