use utf8;
use strict;
use warnings;

package Kernel::Noris::TicketServer::Conversions::CustomerField;

use Moose;

use Data::Dump qw(pp);

extends 'Kernel::Noris::TicketServer::Conversions::StringField';

override 'build_otrs_filter' => sub {
    my ($self, $otrs_obj, $data) = @_;
    if (ref $data eq 'ARRAY') {
        my ($op, @values) = @$data;
        if ($op eq 'not_in') {
            my %not_customer = map (($_,1), @values);
            my  @selected_customers = grep ! $not_customer{$_}, $otrs_obj->{customer}->CustomerIDList();
            $data = [ in => @selected_customers ];
        }
    }
    return $self->SUPER::build_otrs_filter($otrs_obj, $data);
};


1;
