package Kernel::Noris::TicketServer::Conversions::ChoiceField;

use Moose;

use Data::Dump qw(pp);

has 'api' => (is => 'ro', isa => 'Str', required => 1);
has 'otrs' => (is => 'ro', isa => 'Str', required => 1);
has 'otrs_search' => (is => 'ro', isa => 'Str', required => 1);

# Abstrakte Oberklasse, daher keine direkte Tests der Methoden.

sub build_otrs_filter {
    my ($self, $otrs_obj, $data) = @_;
    my ($op, @values);
    if (ref $data ne 'ARRAY') {
        $op = 'in';
        @values = ($data);
    }
    else {
        ($op, @values) = @$data;
    }
    die "cannot handle operator \"$op\" for field $self->{api}\n"
        unless $op =~ /^(not_|)(like|in)$/;
    if ($op eq 'like' || $op eq 'not_like' || $op eq 'not_in' 
        || map $_ =~ /::$/ ? 1 : (), @values) 
    {
        my $choices = $self->all_choices($otrs_obj);
        my $regex = join "|", map $self->value_to_regex($op, $_), @values;
        my @hits;
        if ($op =~ /^not_/) {
            @hits = map $_ =~ $regex ? () : $_, @$choices;
        }
        else {
            @hits = map $_ =~ $regex ? $_ : (), @$choices;
        }
        return ($self->otrs_search, $self->convert_search_values(\@hits));
    }
    elsif ($op eq 'in') {
        return ($self->otrs_search, $self->convert_search_values(\@values));
    }
    else {
        die "cannot handle operator \"$op\" for field $self->{api}\n";
    }
}

sub _value_to_regex {
    my ($self, $op, $value) = @_;
    my $s = quotemeta($value);
    if ($op eq 'like' || $op eq 'not_like') {
        $s =~ s/\\\*/.*/g;
        $s =~ s/\\\?/./g;
    }
    return $s;
}

sub value_to_regex {
    my ($self, $op, $value) = @_;
    my $s = $self->_value_to_regex($op, $value);
    $s = "^$s\$";
    return $s;
}

sub convert_search_values {
    my ($self, $value_list) = @_;
    return $value_list;
}

sub all_choices {
    my ($self, $otrs_obj) = @_;
    die "NOT IMPLEMENTED IN ABSTRACT CLASS";
    # returns a list ref with all possible choices (without any filter applied)
}

sub get_from_otrs_data
{
    my ($self, $otrs, $data) = @_;
    return $data->{$self->otrs};
}



1;
