package Kernel::Noris::TicketServer::Conversions::BooleanField;

use Moose;

use Data::Dump qw(pp);

has 'api' => (is => 'ro', isa => 'Str', required => 1);
has 'otrs' => (is => 'ro', isa => 'Str', required => 1);
has 'otrs_search' => (is => 'ro', isa => 'Str', required => 1);
has 'true_string' => (is => 'ro', isa => 'Str', required => 1);

sub build_otrs_filter {
    my ($self, $otrs_obj, $data) = @_;
    my ($op, @values);
    if (ref $data ne 'ARRAY') {
        $op = 'in';
        @values = ($data);
    }
    else {
        ($op, @values) = @$data;
    }
    die "cannot handle operator \"$op\" for field $self->{api}\n"
        unless $op eq 'in';
    my @found = (0,0);
    for my $value (@values) {
        $found[$value ? 1 : 0] = 1;
    }
    return ($self->otrs_search, []) if ! $found[0] && ! $found[1];  # nichts erlaubt ==> nichts passt
    return () if $found[0] && $found[1];  # beides erlaubt ==> passt immer
    die "cannot search for false value for field $self->{api}\n" if $found[0];
    return ($self->otrs_search, $self->true_string) if $found[1];
    die "unexpected case";
}

sub get_from_otrs_data
{
    my ($self, $otrs, $data) = @_;
    return $data->{$self->otrs} ? 1 : 0;
}



1;
