use strict;
use warnings;
use utf8;

package Kernel::Noris::TicketServer::Conversions;

use Data::Dump qw(pp);

use Kernel::Noris::TicketServer::Conversions::CustomerField;
use Kernel::Noris::TicketServer::Conversions::StringField;
use Kernel::Noris::TicketServer::Conversions::QueueField;
use Kernel::Noris::TicketServer::Conversions::OtrsStatusField;
use Kernel::Noris::TicketServer::Conversions::StatusField;
use Kernel::Noris::TicketServer::Conversions::OtrsStatusTypeField;
use Kernel::Noris::TicketServer::Conversions::OwnerField;
use Kernel::Noris::TicketServer::Conversions::DateTimeField;
use Kernel::Noris::TicketServer::Conversions::VirtualField;
use Kernel::Noris::TicketServer::Conversions::MergeParentField;
use Kernel::Noris::TicketServer::Conversions::PriorityField;
use Kernel::Noris::TicketServer::Conversions::EpochDateTimeField;
use Kernel::Noris::TicketServer::Conversions::TicketTypeField;
use Kernel::Noris::TicketServer::Conversions::LockField;
use Kernel::Noris::TicketServer::Conversions::EmailField;
use Kernel::Noris::TicketServer::Conversions::EstEffortField;
use Kernel::Noris::TicketServer::Conversions::LinkedObjectsField;
use Kernel::Noris::TicketServer::Conversions::OriginField;
use Kernel::Noris::TicketServer::Conversions::SimpleField;
use Kernel::Noris::TicketServer::Conversions::BooleanField;



our %Fields = (
    field( 
        'String',
        api => 'ticket_number', 
        otrs => 'TicketNumber'
    ),
    field( 
        'String',
        api => 'title', 
        otrs => 'Title',
    ),
    field(
        'Customer',
        api => 'kunde',
        otrs => 'CustomerID'
    ),
    field(
        'Owner',
        api => 'owner',
        otrs => 'Owner',
        otrs_search => 'OwnerIDs'
    ),
    field(
        'Queue',
        api => 'queue',
        otrs => 'Queue',
        otrs_search => 'Queues',
    ),
    field(
        'OtrsStatus',
        api => 'otrs_status',
        otrs => 'State',
        otrs_search => 'States',
    ),
    field(
        'Status',
        api => 'status',
        otrs => 'StateType',
        otrs_search => 'StateType',
    ),
    field(
        'OtrsStatusType',
        api => 'status_typ',
        otrs => 'StateType',
        otrs_search => 'StateType',
    ),
    field(
        'DateTime',
        api => 'created',
        otrs => 'Created',
        otrs_search => 'TicketCreateTime',
    ),
    field(
        'DateTime',
        api => 'due',
        otrs => 'EscalationDestinationDate',
        otrs_search => 'TicketEscalationTime',
    ),
    field(
        'EpochDateTime',
        api => 'pending_until',
        otrs => 'RealTillTimeNotUsed',
        otrs_search => 'TicketPendingTime',
    ),
    field(
        'Virtual',
        api => 'ticket_url',
        fn => sub { 
                my ($data, $otrs) = @_;
                return 'http'
                  . ( $otrs->{config}->{'HttpType'} ? 's' : '' ) . '://'
                  . $otrs->{config}->{'TicketServer::Ticket_URL_FQDN'} . '/'
                  . $otrs->{config}->{'ScriptAlias'}
                  . 'index.fpl?Action=AgentTicketZoom&TicketID='
                  . $data->{TicketID};
            },
    ),
    field(
        'Email',
        api => 'ticket_email',
    ),
    field(
        'MergeParent',
        api => 'merge_parent',
        recursive_search => ''
    ),
    field(
        'MergeParent',
        api => 'merge_root',
        recursive_search => 1
    ),
    field(
        'LinkedObjects',
        api => 'confitems',
        object_type => 'Confitem',
        link_type => 'Normal',
        link_direction => 'Source'
    ),
    field(
        'LinkedObjects',
        api => 'leitungen',
        object_type => 'Leitung',
        link_type => 'Normal',
        link_direction => 'Source'
    ),
    field(
        'Origin',
        api => 'origin'
    ),
    field(
        'Priority',
        api => 'priority',
        otrs => 'Priority',
        otrs_search => 'Priorities',
    ),
    field(
        'String',
        api => 'info',
        otrs => 'TicketFreeText1',
    ),
    field(
        'EstEffort',
        api => 'est_effort',
        otrs => 'TicketFreeText2',
    ),
    field(
        'TicketType',
        api => 'type',
        otrs => 'Type',
        otrs_search => 'Types',
    ),
    field(
        'Lock',
        api => 'locked',
        otrs => 'Lock',
        otrs_search => 'Locks',
    ),
    field(
        'Simple',
        api => 'customer_visibility',
        otrs => 'ArticleCustomerVisibility'
    ),
    field(
        'DateTime',
        api => "incident_start",
        otrs => 'TicketFreeTime2',
        otrs_search => 'TicketFreeTime2',
    ),
    field(
        'DateTime',
        api => 'incident_response',
        otrs => 'TicketFreeTime5',
        otrs_search => 'TicketFreeTime5',
    ),
    field(
        'DateTime',
        api => 'incident_resolved',
        otrs => 'TicketFreeTime3',
        otrs_search => 'TicketFreeTime3',
    ),
    field(
        'String',
        api => 'incident_type',
        otrs => 'TicketFreeText15',
        otrs_search => 'TicketFreeText15',
    ),
    field(
        'String',
        api => 'incident_cause',
        otrs => 'TicketFreeText16',
    ),
    field(
        'Boolean',
        api => 'sla_relevant',
        otrs => 'TicketFreeText3',
        otrs_search => 'TicketFreeText3',
        true_string => 'ja',
    ),
);
    
sub field {
    my ($typ, %param) = @_;
    my $package = 'Kernel::Noris::TicketServer::Conversions::' . $typ . 'Field';
    return (
        $param{api} => $package->new(%param)
    );
}

1;
