# --
# Kernel/System/Ticket/Permission/TicketTypeCheck.pm - the sub
# module of the global ticket handle
# Copyright (C) 2009 Stelios Gikas <stelios.gikas@noris.net>
#  for Noris Network  http://www.noris.net/
# --
# $Id$
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl-2.0.txt.
# --

package Kernel::Noris::System::Ticket::CustomerPermission::ArticleTypeCheck;

use strict;
use warnings;

use vars qw(@ISA $VERSION);
$VERSION = qw($Revision: 2.3.3 $) [1];

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # get needed objects
    for (qw(LogObject TicketObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    return $Self;
}

sub Run {
    my ( $Self, %Param ) = @_;

    # check needed stuff
    for (qw(TicketID)) {
        if ( !$Param{$_} ) {
            $Self->{LogObject}->Log( Priority => 'error', Message => "Need $_!" );
            return;
        }
    }

    # get article index
    my @Index = $Self->{TicketObject}->ArticleIndex( TicketID => $Param{TicketID});

    if ( !@Index ) {
        $Self->{LogObject}->Log(
            Priority => 'info',
            Message  => "No article found for TicketID $Param{TicketID}!",
        );
        return;
    }

    # return latest non internal article
    for my $ArticleID (@Index) {
        my %Article = $Self->{TicketObject}->ArticleGet( ArticleID => $ArticleID );
        my $Typ = $Article{ArticleType};
        return 1 if 
            $Typ =~ /-external$/i 
            || $Typ !~ /int/i && $Article{SenderType} eq "customer";
    }

    return;
}

1;
