package Kernel::Noris::Output::HTML::NavBarAgentTicketQueue;

use strict;
use warnings;

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # get needed objects
    for (qw(ConfigObject LogObject DBObject TicketObject LayoutObject UserID)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }
    $Self->{CustomQueue} = $Self->{ConfigObject}->Get('Ticket::CustomQueue') || '???';
    return $Self;
}

sub Run {
    my ( $Self, %Param ) = @_;

    my %Return = ();

    my %QueueCount = $Self->{TicketObject}->TicketAcceleratorIndex(
            UserID => $Self->{UserID},
            QueueID => 0,
            ShownQueueIDs => []
        );
    my $Text = $Self->{LayoutObject}->{LanguageObject}->Get('Available Tickets')
            . " ($QueueCount{TicketsAvail})";
    $Return{'1900000'} = {
        Block => 'ItemPersonal',
         'AccessKey' => 'o',
         'Description' => 'Overview of all open Tickets',
         'Image' => 'overview.png',
         'Link' => 'Action=AgentTicketQueue',
         'Name' => $Text,
    };
    return %Return;
}

1;
