
=head1 NAME

Kernel::Noris::Output::HTML::FilterTextSignature

=head1 SYNOPSIS

Text-Filter zur Ausgabe von Signaturen in einen DIV-Block, den mann
über JS anzeigen, verstecken kann.

Verwandelt alle Blöcke der Form

  --
  Zeile 1
  Zeile 2
  Zeile 3

in 

  <a href="javascript:toggleSignature('divID')">--</a>
  <div id="divID">
  Zeile 1
  Zeile 2
  Zeile 3
  </div>

=head1 Siehe auch

Kernel::Output::HTML::Layout::Ascii2Html()

=cut

package Kernel::Noris::Output::HTML::FilterTextSignature;

use strict;
use warnings;

use vars qw(@ISA $VERSION);
$VERSION = qw($Revision: 2.3.3 $) [1];

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # check needed objects
    for (qw(LogObject LayoutObject TicketObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    return $Self;
}

sub Pre {
    my ( $Self, %Param ) = @_;

    return $Param{Data};
}

my $random_number = 0;
sub _SigBlock {
    my ($Self, $SigBlock) = @_;

    ++$random_number;
    return <<_
<a href="javascript:void(toggleSignature('SigID$random_number'))">--</a>
<div id="SigID$random_number" style="display:none">$SigBlock</div>
_
}

sub Post {
    my ( $Self, %Param ) = @_;
    
    if ( !defined $Param{Data} ) {
        $Self->{LogObject}->Log( Priority => 'error', Message => 'Need Data!' );
        $Self->{LayoutObject}->FatalDie();
    }
    ${ $Param{Data} } =~ s/(?<=\n)(-- ?)\n(.*)/$Self->_SigBlock($2)/es ;
    return $Param{Data};

    #my $txt = ${ $Param{Data} };
    #if ($txt =~ m/^(-- ?)$/m)
    #{
    #    $txt = $` . $Self->_SigBlock ($');
    #}
    #return \$txt;
}

1;
