
=head1 NAME

Kernel::Noris::Output::HTML::FilterTextLinkReplace

=head1 SYNOPSIS

Text-Filter zur Ausgabe von Ticket-Nummern und Wiki-Seiten als Link.

Verwandelt alle Angaben zu im otrs existierenden Tickets
in der Form
 Ticket #123456
 ticket 123456
 #123456
in einen Link.

gleichzeitig verwandelt es alle Angaben zu Seiten im noris-Wiki
in der Form
 [[Name]]
in einen Link.

Siehe #10002344


=head1 Siehe auch

Kernel::Output::HTML::Layout::Ascii2Html()

=cut

package Kernel::Noris::Output::HTML::FilterTextLinkReplace;

use strict;
use warnings;

use vars qw(@ISA $VERSION);
$VERSION = qw($Revision: 2.3.3 $) [1];

sub new {
    my ( $Type, %Param ) = @_;

    # allocate new hash for object
    my $Self = {};
    bless( $Self, $Type );

    # check needed objects
    for (qw(LogObject LayoutObject TicketObject)) {
        $Self->{$_} = $Param{$_} || die "Got no $_!";
    }

    return $Self;
}

sub Pre {
    my ( $Self, %Param ) = @_;

    return $Param{Data};
}

sub _WikiLink {
    my ($Self, $WikiName) = @_;
    my $WikiNameEncoded = $WikiName;
    return "<a href=\"/wiki/index.php/$WikiNameEncoded\">[[$WikiName]]</a>";
}

sub _TicketLink {
    my ( $Self, $TicketNumber, $Prefix ) = @_;
    $Prefix = '' unless defined $Prefix;
    my $TicketID = $Self->{TicketObject}->TicketCheckNumber( Tn => $TicketNumber )
      or return "$Prefix$TicketNumber";
    my %Ticket = $Self->{TicketObject}->TicketGet(
        TicketID => $TicketID,
        UserID   => $Self->{UserID}
    ) or return "$Prefix$TicketNumber";
    my $CssStyle =
      $Ticket{StateType} =~ /^closed|^merged|^removed/
      ? 'style="text-decoration: line-through" '
      : '';
    return "<a ${CssStyle}title=\"Ticket #$TicketNumber: $Ticket{Title}\" href=\"$Self->{LayoutObject}->{Baselink}Action=AgentTicketZoom&TicketID=$TicketID\">$Prefix$TicketNumber</a>";
}

sub _ArticleLink {
    my ( $Self, $ArticleID ) = @_;

    my %Article = $Self->{TicketObject}->ArticleGet( ArticleID => $ArticleID, )
      or return "Artikel $ArticleID";

    my $TicketID = $Article{TicketID};
    my %Ticket   = $Self->{TicketObject}->TicketGet(
        TicketID => $TicketID,
        UserID   => $Self->{UserID}
    ) or return "Artikel $ArticleID";

    my $CssStyle =
      $Ticket{StateType} =~ /^closed|^merged|^removed/
      ? 'style="text-decoration: line-through" '
      : '';

    return "<a ${CssStyle}title=\" Artikel $ArticleID: $Article{Subject} von Ticket #$TicketID: $Ticket{Title}\" href=\"$Self->{LayoutObject}->{Baselink}Action=AgentTicketZoom&amp;TicketID=$TicketID&amp;ArticleID=$ArticleID\">Artikel $ArticleID</a>";
}

sub Post {
    my ( $Self, %Param ) = @_;
    
    if ( !defined $Param{Data} ) {
        $Self->{LogObject}->Log( Priority => 'error', Message => 'Need Data!' );
        $Self->{LayoutObject}->FatalDie();
    }

    my @txt = split /
               (                 # Ticket, ticket, "#"
                   \b
                   [Tt]icket\s*
                 |
                   \#
               )
               ( \d{1,13} )      # 123456789 (ticket number)
               \b
             |
               \b
               Artikel \s*
               ( \d{1,13} )      # 123456789 (article number)
               \b
             |
               \[\[
               ( [^\]]*? )       # Wiki-title
               \]\]
          /x, ${ $Param{Data} };

    my $txt = '';
    my $is_txt;
    while (@txt) {
        if ( $is_txt = !$is_txt ) { # Diesen...
            my $text = shift @txt;
            $txt .= $text;
        }
        else { # ... und diesen Zweig abwechselnd durchlaufen.
            my ( $prefix, $ticket, $article, $wiki ) = splice @txt, 0, 4;

            if ( defined $wiki ) {
                $txt .= $Self->_WikiLink($wiki);
            }
            elsif ( defined $article ) {
                $txt .= $Self->_ArticleLink($article);
            }
            elsif ( defined $ticket ) {
                $txt .= $Self->_TicketLink( $ticket, $prefix );
            }
        }
    }

    return \$txt;
}

1;
