# --
# Kernel/Language/en.pm - provides en_US languag translation
# Copyright (C) 2001-2009 OTRS AG, http://otrs.org/
# --
# $Id$
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::en;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 2.3.3 $) [1];

sub Data {
    my $Self = shift;

    # http://en.wikipedia.org/wiki/Date_and_time_notation_by_country#United_States
    # month-day-year (e.g., "12/31/99")

    # $$START$$
    # Last translation file sync: Thu Apr  9 10:12:50 2009

    # possible charsets
    $Self->{Charset} = ['us-ascii', 'UTF-8', 'iso-8859-1', 'iso-8859-15', ];

    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat}          = '%M/%D/%Y %T';
    $Self->{DateFormatLong}      = '%T - %M/%D/%Y';
    $Self->{DateFormatShort}     = '%M/%D/%Y';
    $Self->{DateInputFormat}     = '%M/%D/%Y';
    $Self->{DateInputFormatLong} = '%M/%D/%Y - %T';

    # maybe nothing ... or help texts
    $Self->{Translation} = {
        'May_long' => 'May',
        'History::Move' => 'Ticket moved into Queue "%s" (%s) from Queue "%s" (%s).',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'New Ticket [%s] created (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp for [%s]. %s',
        'History::SendAutoReject' => 'AutoReject sent to "%s".',
        'History::SendAutoReply' => 'AutoReply sent to "%s".',
        'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
        'History::Forward' => 'Forwarded to "%s".',
        'History::Bounce' => 'Bounced to "%s".',
        'History::SendAnswer' => 'Email sent to "%s".',
        'History::SendAgentNotification' => '"%s"-notification sent to "%s".',
        'History::SendCustomerNotification' => 'Notification sent to "%s".',
        'History::EmailAgent' => 'Email sent to customer.',
        'History::EmailCustomer' => 'Added email. %s',
        'History::PhoneCallAgent' => 'Agent called customer.',
        'History::PhoneCallCustomer' => 'Customer called us.',
        'History::NewInternalTicket'        => 'New internal Ticket created',
        'History::AddNote' => 'Added note (%s)',
        'History::Lock' => 'Locked ticket.',
        'History::Unlock' => 'Unlocked ticket.',
        'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Updated: %s',
        'History::PriorityUpdate' => 'Changed priority from "%s" (%s) to "%s" (%s).',
        'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop-Protection! No auto-response sent to "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Updated: %s',
        'History::StateUpdate' => 'Old: "%s" New: "%s"',
        'History::TicketFreeTextUpdate' => 'Updated: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Customer request via web.',
        'History::TicketLinkAdd' => 'Added link to ticket "%s".',
        'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',
        'History::SystemRequest' => 'System Request (%s).',
        'FollowupRTExplanation' => 'the destination queue is still RT managed',
        'UnmonitoredStatusExplanation' => 'The ticket link will be displayed but has no further meaning. The tickets can be handled independently.',
        'MonitoredStatusExplanation' => '"Monitored Status" means that the main ticket can only be closed when all sub tickets are also closed. In addition, a pending main ticket will be "waked up" if a sub ticket gets closed - nice if you wait for something being done.',
        'ReplyToCustomerExplanation' => 'The response will be sent to the customer contact of this ticket and will be visible on the customer ticket interface.',
        'RespondInternallyExplanation' => '- to other employees, replies are directed into the ticket',
        'ForwardExplanation' => 'Forward this by email to somebody else',
        'SubTicketExplanation' => 'creates a new ticket as "sub ticket". The new ticket will inherit the customer from the main ticket, but the customer contact will be set so that responses from the sub ticket enter the main ticket (unless the destination is explicitly overwritten). A sub ticket is suited for delegation a part of a task (e. g. have the sysadmins install a server) if you still want to deal with the customer communication.',
        'WatchTicketExplanation' => 'create a main ticket to the current ticket, which will become the sub ticket of the main ticket. The new man ticket will be owned by yourself, and you will probably want to set it to a pending state. This way, as soon as the sub ticket gets closed, your ticket will be waked uip. A watch ticket comes close to subscribe a ticket in RT.',
        'ProjectTicketExplanation' => 'very similar to a sub ticket, only that the customer contact will also be inherited from the main ticket, and you become owner of the new sub ticket. Its purpose is to help organizing complex tasks for yourself.',
        '3rdPartyTicketExplanation' => 'like a project ticket, it opens a sub ticket inheriting the customer contact from the main ticket. In contrast to the project ticket, the text you compose will immediately be turned into an email and sent away. This type of ticket is for the service desk, when they need to send a sub ticket to a third party service contractor.',
        'AgentAnswerComposeDeniedInternal' => 'Since the article is marked as internal, this is normally not permitted.',
        'AgentAnswerComposeDenied' => '... is not available since you have no permissions for this queue or the ticket is owned by somebody else',
        'AgentAnswerFollowupMainSubDenied' => 'Other options are not available since you habe no permissions for this queue.',
        'AgentAnswerNoteDenied' => '... is not available since you have no permissions for this queue or the ticket is owned by somebody else',
        'NoteExplanation' => 'Add a comment to the ticket',

    };
    # $$STOP$$
    return;
}

1;
