<?
#Prueft ob die Form der ISBN-Nummer korrekt ist
function isbnregextest($isbn)
{
	if(strlen($isbn)=='13' || (strlen($isbn)=='17'))
	{
		$count='0';
		if(strlen($isbn)=='13')
		{
			$isbn10=str_replace('-', '', $isbn, &$count);
			if($count=='3' && preg_match('/^[0-9]*[xX]?$/', $isbn10))
			return TRUE;
			else
			return FALSE;
		}
		elseif(strlen($isbn)=='17')
		{
			$isbn13=str_replace('-', '', $isbn, &$count);
			if($count=='4' && preg_match('/^[0-9]*[xX]?$/', $isbn13))
			return TRUE;
			else
			return FALSE;
		}
	}
	else
	return FALSE;
}

#Prüft ob die eingegebene ISBN auch mit der Checksumme (letzte Zahl) uebereinstimmt
function isbnchecksum($isbn)
{
	if(strlen($isbn)==13)
	{
		$isbnclean = preg_replace("/([^\d])/","",substr($isbn,0,-1));
		if(strlen($isbnclean) != 9)
		return false;
		$checksum=0;
		for($i=0;$i<strlen($isbnclean);$i++)
		$checksum=$checksum+((10-$i)*$isbnclean[$i]);
		$checksum=11-($checksum%11);
		if($checksum==10) $checksum='x';
		if($checksum==11) $checksum=0;
		if(strtolower($isbn[strlen($isbn)-1])==$checksum)
		return TRUE;
		else
		return FALSE;
	}
	elseif(strlen($isbn)==17)
	{
		$isbnclean = preg_replace("/([^\d])/","",$isbn);
		if(strlen($isbnclean) != 13)
		return false;
		$checksum=($isbnclean[0]+$isbnclean[2]+$isbnclean[4]+$isbnclean[6]+$isbnclean[8]+$isbnclean[10]+$isbnclean[12]+(3*($isbnclean[1]+$isbnclean[3]+$isbnclean[5]+$isbnclean[7]+$isbnclean[9]+$isbnclean[11])))%10;
		if($checksum==0)
		return TRUE;
		else
		return FALSE;
	}
}

#Liefert die ID des Mitarbeiters in der Datenbank
function mitarbeiterid($kurzname)
{
	$sql=sprintf("SELECT id from mitarbeiter where mitarbeiter.kurzname=\"%s\"", mysql_real_escape_string($kurzname));
	$sql=mysql_query($sql);
	$row=mysql_fetch_assoc($sql);
	return($row['id']);
}

#Fügt einen Mitarbeiter der Datenbank hinzu
function addmitarbeiter($kurzname)
{
	$sql=sprintf("INSERT INTO mitarbeiter (kurzname) VALUES (\"%s\")", mysql_real_escape_string($kurzname));
	mysql_query($sql);
	return(mysql_insert_id());
}

#Liefert die ID des vorhandenen Verlags oder legt ihn an und liefert dann die ID
function verlagidoradd($verlag)
{
	#ID des Verlags abfragen
	$sql=sprintf("SELECT id from verlag where verlag.name=\"%s\"", mysql_real_escape_string($verlag));
	$sql=mysql_query($sql);
	$row=mysql_fetch_assoc($sql);
	$verlagid=$row['id'];

	#wenn noch nicht in DB dann Verlag eintragen
	if($verlagid=='')
	{
		$sql=sprintf("INSERT INTO verlag (name) VALUES (\"%s\")", mysql_real_escape_string($verlag));
		mysql_query($sql);
		$verlagid=mysql_insert_id();
	}
	return $verlagid;
}

#Liefert die ID des Autors, bzw. wird ihn anlegen wenn er noch nicht in der Datenbank existiert
function autoridoradd($vorname, $nachname)
{
	#ID des Autors abfragen
	$sql=sprintf("SELECT id FROM autor where autor.nachname=\"%s\" AND autor.vorname=\"%s\"", mysql_real_escape_string($nachname), mysql_real_escape_string($vorname));
	$sql=mysql_query($sql);
	$row=mysql_fetch_assoc($sql);
	$autorid=$row['id'];

	#wenn noch nicht in DB dann Autor eintragen
	if($autorid=='')
	{
		$sql=sprintf("INSERT INTO autor (nachname, vorname) VALUES (\"%s\", \"%s\")", mysql_real_escape_string($nachname), mysql_real_escape_string($vorname));
		mysql_query($sql);
		$autorid=mysql_insert_id();
	}
	return $autorid;
}

#Liefert die ID der Kategorie aus der Datenbank
function kategorieid($kategorie)
{
	$sql=sprintf("SELECT id from kategorie where kategorie.name=\"%s\"", mysql_real_escape_string($kategorie));
	$sql=mysql_query($sql);
	$row=mysql_fetch_assoc($sql);
	return($row['id']);
}

#Funktion zum Eintragen von Kategorien
function kategorieadd($kategorie)
{
	$kategorieid=kategorieid($kategorie);
	if($kategorieid=='')
	{
		$sql=sprintf("INSERT INTO kategorie (name) VALUES (\"%s\")", mysql_real_escape_string($kategorie));
		if(!mysql_query($sql))
		return FALSE;
	}
	return TRUE;
}

#Funktion zum Austragen von Kategorien
function kategoriedelete($kategorie)
{
	$kategorieid=kategorieid($kategorie);
	$sql=sprintf("SELECT * FROM kategorisierung WHERE kategorie=%d", mysql_real_escape_string($kategorieid));
	$sql=mysql_query($sql);
	$kategorisierung=mysql_num_rows($sql);
	if($kategorieid!='' && $kategorisierung=='0')
	{
		$sql=sprintf("DELETE FROM kategorie WHERE id=%d", mysql_real_escape_string($kategorieid));
		mysql_query($sql);
		if(mysql_errno()!='0')
		return FALSE;
		return TRUE;
	}
	return FALSE;
}

#Funktion zum Eintragen von Buechern. Gibt TRUE oder FALSE zurueck
function bucheintragen()
{
	$fehler=0;
	$gesamtautoren=array();
	#Beginn Transaktion
	$sql=sprintf("START TRANSACTION");
	if(!mysql_query($sql))
	$fehler=1;

	#Alle Kategorien die in der Textarea stehen, sollen auch hinzugefuegt werden
	if(isset($_POST['newkategorie']))
	{
		$_POST['newkategorie']=str_replace("\r\n", "\n", $_POST['newkategorie']);
		$_POST['newkategorie']=str_replace("\r", "\n", $_POST['newkategorie']);
		$kategorien=explode("\n", $_POST['newkategorie']);
		if(is_array($kategorien))
		{
			foreach($kategorien as $name)
			if(strlen($name)>1)
			if(!kategorieadd($name))
			echo '<p style="color:#FF0000; font-weight:bold;">Eintragen der Kategorie '.htmlspecialchars($name).' hat nicht geklappt</p>'."\n";
			else
			$_POST['kategorieauswahl'][]=$name;
		}
		else
		{
			if(strlen($kategorien)>1)
			if(!kategorieadd($kategorien))
			echo '<p style="color:#FF0000; font-weight:bold;">Eintragen der Kategorie '.htmlspecialchars($kategorien).' hat nicht geklappt</p>'."\n";
			else
			$_POST['kategorieauswahl'][]=$kategorien;
		}
	}

	#ID des Eigentuemers abfragen
	$mitarbeiter=mitarbeiterid($_POST['eigentuemer']);

	#wenn noch nicht in DB dann Mitarbeiter eintragen
	if($mitarbeiter=='')
	$mitarbeiter=addmitarbeiter($_POST['eigentuemer']);

	#ID des Eintraegers abfragen
	$eintraeger=mitarbeiterid($_SERVER['PHP_AUTH_USER']);

	#wenn noch nicht in DB dann Eintraeger eintragen
	if($eintraeger=='')
	$eintraeger=addmitarbeiter($_SERVER['PHP_AUTH_USER']);

	#ID des Verlags holen bzw. Verlag hinzufuegen
	$verlag=verlagidoradd($_POST['verlag']);

	#ID des Autors holen bzw. Autor hinzufuegen
	for($counter=0; $counter<$_POST['autoranzahl']; $counter++)
	$gesamtautoren[]=autoridoradd($_POST['vorname'][$counter], $_POST['nachname'][$counter]);

	#Wenn Auflage 0 ist, bzw. wenn keine gesetzt wurde, wird automatisch 1 eingetragen
	if(!isset($_POST['auflage']))
	$_POST['auflage']=1;
	else
	{
		if($_POST['auflage']==0)
		$_POST['auflage']=1;
	}
	if(is_numeric($mitarbeiter) && $mitarbeiter>0)
	{
		$sql=sprintf("INSERT INTO buch (titel, isbn, auflage, jahr, verlag, eigentuemer, eintragedatum, angelegtvon, notiz, bildlink, bild, amazonlink) VALUES (\"%s\", \"%s\", %d, %d, \"%s\", %d, NOW(), %d,\"%s\", \"%s\", \"%s\", \"%s\")", mysql_real_escape_string($_POST['titel']), mysql_real_escape_string($_POST['isbn']), mysql_real_escape_string($_POST['auflage']), mysql_real_escape_string($_POST['jahr']), mysql_real_escape_string($verlag), mysql_real_escape_string($mitarbeiter), mysql_real_escape_string($eintraeger), mysql_real_escape_string($_POST['notiz']), mysql_real_escape_string($_POST['bildlink']), mysql_real_escape_string(getbinaryfrompicture($_POST['bildlink'])), mysql_real_escape_string($_POST['amazonlink']));
		if(!mysql_query($sql))
		$fehler=1;
		else
		$buch=mysql_insert_id();
		foreach($gesamtautoren as $autor)
		{
			$sql=sprintf("INSERT INTO buchautor (buch, autor) VALUES (%d, %d)", mysql_real_escape_string($buch), mysql_real_escape_string($autor));
			if(!mysql_query($sql))
			$fehler=1;
		}
	
		if(isset($_POST['kategorieauswahl']))
		{
			foreach($_POST['kategorieauswahl'] as $kategoriename)
			{
				$kategorie=kategorieid($kategoriename);
				$sql=sprintf("INSERT INTO kategorisierung (kategorie, buch) VALUES (%d, %d)", mysql_real_escape_string($kategorie), mysql_real_escape_string($buch));
				if(!mysql_query($sql))
				$fehler=1;
			}
		}
		if(isset($_POST['entliehenan']) && strlen($_POST['entliehenan'])>1)
		{
			$erstentleiher=mitarbeiterid($_POST['entliehenan']);
			if($erstentleiher=='')
			$erstentleiher=addmitarbeiter($_POST['entliehenan']);

			if(!buchausleihen($buch,$_POST['entliehenan'], "---"))
			$fehler=1;
		}
	}
	if($fehler==0)
	{
		#Eintraege commiten
		$sql=sprintf("COMMIT");
		$sql=mysql_query($sql);
		return TRUE;
	}
	else
	{
		#Eintraege rollback
		$sql=sprintf("ROLLBACK");
		$sql=mysql_query($sql);
		return FALSE;
	}
}

#Editiert das Buch was von der admin.php mittels $_POST uebergeben wurde und liefert TRUE oder FALSE
function bucheditieren()
{
	$fehler=0;
	#Beginn Transaktion
	$sql=sprintf("START TRANSACTION");
	if(!mysql_query($sql))
	$fehler=1;

	#Alle Kategorien die in der Textarea stehen, sollen auch hinzugefuegt werden
	if(isset($_POST['newkategorie']))
	{
		$_POST['newkategorie']=str_replace("\r\n", "\n", $_POST['newkategorie']);
		$_POST['newkategorie']=str_replace("\r", "\n", $_POST['newkategorie']);
		$kategorien=explode("\n", $_POST['newkategorie']);
		if(is_array($kategorien))
		{
			foreach($kategorien as $name)
			if(strlen($name)>1)
			if(!kategorieadd($name))
			echo '<p style="color:#FF0000; font-weight:bold;">Eintragen der Kategorie '.htmlspecialchars($name).' hat nicht geklappt</p>'."\n";
			else
			$_POST['kategorieauswahl'][]=$name;
		}
		else
		{
			if(strlen($kategorien)>1)
			if(!kategorieadd($kategorien))
			echo '<p style="color:#FF0000; font-weight:bold;">Eintragen der Kategorie '.htmlspecialchars($kategorien).' hat nicht geklappt</p>'."\n";
			else
			$_POST['kategorieauswahl'][]=$kategorien;
		}
	}

	#ID des Eigentuemers abfragen
	$mitarbeiter=mitarbeiterid($_POST['eigentuemer']);

	#wenn noch nicht in DB dann Mitarbeiter eintragen
	if($mitarbeiter=='')
	$mitarbeiter=addmitarbeiter($_POST['eigentuemer']);

	#ID des Verlags holen bzw. Verlag hinzufuegen
	$verlag=verlagidoradd($_POST['verlag']);

	#ID des Autors holen bzw. Autor hinzufuegen
	for($counter=0; $counter<$_POST['autoranzahl']; $counter++)
	$gesamtautoren[]=autoridoradd($_POST['vorname'][$counter], $_POST['nachname'][$counter]);

	#Wenn Auflage 0 ist, bzw. wenn keine gesetzt wurde, wird automatisch 1 eingetragen
	if(!isset($_POST['auflage']))
	$_POST['auflage']=1;
	else
	{
		if($_POST['auflage']==0)
		$_POST['auflage']=1;
	}

	if(is_numeric($mitarbeiter) && $mitarbeiter>0)
	{
		#Eigenschaften in der Tabelle "Buch" aendern
		$sql=sprintf("UPDATE buch SET titel=\"%s\", isbn=\"%s\", auflage=%d, jahr=%d, notiz=\"%s\", status=%d, eigentuemer=%d, verlag=%d, bildlink=\"%s\", bild=\"%s\", amazonlink=\"%s\" WHERE id=%d", mysql_real_escape_string($_POST['titel']), mysql_real_escape_string($_POST['isbn']), mysql_real_escape_string($_POST['auflage']), mysql_real_escape_string($_POST['jahr']), mysql_real_escape_string($_POST['notiz']), mysql_real_escape_string($_POST['status']), mysql_real_escape_string($mitarbeiter), mysql_real_escape_string($verlag), mysql_real_escape_string($_POST['bildlink']), mysql_real_escape_string(getbinaryfrompicture($_POST['bildlink'])), mysql_real_escape_string($_POST['amazonlink']), mysql_real_escape_string($_POST['id']));
		if(!mysql_query($sql))
		$fehler=1;

		#Vorhandene Beziehung zu Autoren loeschen
		$sql=sprintf("DELETE FROM buchautor WHERE buch=%d", mysql_real_escape_string($_POST['id']));
		if(!mysql_query($sql))
		$fehler=1;

		if(is_array($gesamtautoren))
		{
			foreach($gesamtautoren as $autor)
			{
				$sql=sprintf("INSERT INTO buchautor (buch, autor) VALUES (%d, %d)", mysql_real_escape_string($_POST['id']), mysql_real_escape_string($autor));
				if(!mysql_query($sql))
				$fehler=1;
			}
		}

		#Vorhandene Beziehung zu Kategorien loeschen
		$sql=sprintf("DELETE FROM kategorisierung WHERE buch=%d", mysql_real_escape_string($_POST['id']));
		if(!mysql_query($sql))
		$fehler=1;

		#Neue Beziehung zu Kategorien eintragen
		if(isset($_POST['kategorieauswahl']))
		{
			foreach($_POST['kategorieauswahl'] as $kategoriename)
			{
				$kategorie=kategorieid($kategoriename);
				$sql=sprintf("INSERT INTO kategorisierung (kategorie, buch) VALUES (%d, %d)", mysql_real_escape_string($kategorie), mysql_real_escape_string($_POST['id']));
				if(!mysql_query($sql))
				$fehler=1;
			}
		}
	}  
	if($fehler)
	{
		#Bei Fehler, rollback
		$sql=sprintf("ROLLBACK");
		mysql_query($sql);
		return FALSE;
	}
	else
	{
		#Bei Erfolg, commit
		$sql=sprintf("COMMIT");
		mysql_query($sql);
		return TRUE;
	}
}

#Falls magic_quotes aktiv ist, werden mittels strpslashes alle \ die automatisch angefuegt wurden, wieder entfernt
function umwandlung()
{
	if(get_magic_quotes_gpc())
	{
		foreach($_POST as $index => $wert)
		{
			if(is_array($_POST[$index]))
			{
				foreach($_POST[$index] as $index2 => $wert2)
				$_POST[$index][$index2]=stripslashes($wert2);
			}
			else
			$_POST[$index]=stripslashes($wert);
		}
	}
}

#Leiht das Buch mit der $buchid aus, und gibt es dem $entleiher. Gibt TRUE oder FALSE zurueck
function buchausleihen($buchid, $entleiher, $adminuser)
{
	$sql=sprintf("SELECT buch.titel, ausleihe.id, ausleihe.buch, ausleihe.mitarbeiter, mitarbeiter.kurzname as entliehenvon FROM ausleihe INNER JOIN mitarbeiter ON mitarbeiter.id=ausleihe.mitarbeiter INNER JOIN buch ON buch.id=ausleihe.buch WHERE ende is NULL AND ausleihe.buch=%d", mysql_real_escape_string($buchid));
	if($sql=mysql_query($sql))
	{
		if(mysql_num_rows($sql)>0)
		{
			$row=mysql_fetch_assoc($sql);
			if($row['entliehenvon']==$entleiher)
			{
			  echo '<p style="color:#FF0000; font-weight:bold;">Du hast das Buch "'.$row['titel'].'" schon ausgeliehen.</p>'."\n";
			  return TRUE;
			}
			else
			{
				if(is_array($adminuser))
				{
					if(!(in_array($entleiher, $adminuser)))
					{
						echo '<p style="color:#FF0000; font-weight:bold;">Das Buch "'.$row['titel'].'" hat sich schon '.$row['entliehenvon'].' ausgeliehen.</p>'."\n";
						return TRUE;
					}
					else
					{
						$sql=sprintf("UPDATE ausleihe SET ende=NOW() WHERE buch=%d AND mitarbeiter=(SELECT id FROM mitarbeiter WHERE kurzname=\"%s\") AND ende is NULL", mysql_real_escape_string($buchid), mysql_real_escape_string($row['entliehenvon']));
						mysql_query($sql);
					}
				}
				else
				{
					echo '<p style="color:#FF0000; font-weight:bold;">Das Buch "'.$row['titel'].'" hat sich schon '.$row['entliehenvon'].' ausgeliehen.</p>'."\n";
					return TRUE;
				}
			}
		}
	}
	$sql=sprintf("INSERT INTO ausleihe (buch, mitarbeiter, beginn) VALUES (%d, (SELECT id FROM mitarbeiter WHERE kurzname=\"%s\"), NOW())", mysql_real_escape_string($buchid), mysql_real_escape_string($entleiher));
	if(!mysql_query($sql))
	return FALSE;
	return TRUE;
}

#Das ausgeliehene Buch wird wieder zurueck gelegt indem ein Enddatum in die ausleih-Tabelle eingetragen wird. Es wird TRUE oder FALSE zurueck gegeben
function buchzurueck($buchid)
{
	$sql=sprintf("UPDATE ausleihe SET ende=NOW() WHERE buch=%d AND mitarbeiter=(SELECT id FROM mitarbeiter WHERE kurzname=\"%s\") AND ende is NULL", mysql_real_escape_string($buchid), mysql_real_escape_string($_SERVER['PHP_AUTH_USER']));
	if(mysql_query($sql))
	return TRUE;
	else
	return FALSE;
}

#Der Admin hat die Option ein Buch freizugeben, welches sich gerade ein anderer ausgeliehen hat
function admin_buchfreigeben($buchid, $adminuser)
{
	if(is_array($adminuser))
	{
		if((in_array($_SERVER['PHP_AUTH_USER'], $adminuser)))
		{
			$sql=sprintf("SELECT mitarbeiter FROM ausleihe WHERE buch=%d AND ende is NULL", mysql_real_escape_string($buchid));
			$sql=mysql_fetch_assoc(mysql_query($sql));
			$mitarbeiterid=$sql['mitarbeiter'];
			$sql=sprintf("UPDATE ausleihe SET ende=NOW() WHERE buch=%d AND mitarbeiter=%d AND ende is NULL", mysql_real_escape_string($buchid), mysql_real_escape_string($mitarbeiterid));
			if(mysql_query($sql))
			return TRUE;
			else
			return FALSE;
		}
	}
}

function isbn10to13($isbn10)
{
	$isbnclean = preg_replace("/([^\d])/","",substr($isbn10,0,-1));
	if(strlen($isbnclean) != 9)
	return $isbn10;
	$isbn="978".$isbnclean;
	$check=0;
	for($i=0;$i<12;$i++) 
	$check+=(($i%2)*2+1)*$isbn{$i};
	$check=(10-($check%10))%10;
	if($check==10) $check='x';
	if($check==11) $check=0;
	return "978-".substr($isbn10,0,12).$check;
}

function isbn13to10($isbn13)
{
	$isbnclean=preg_replace("/([^\d])/","",substr($isbn13,0,-1));
	if(strlen($isbnclean)!=12)
	return $isbn13;
	$isbn=substr($isbnclean,3,9);
	$check=0;
	for($i=0;$i<9;$i++)
	$check+=((10-$i)*$isbn[$i]);
	$check=11-($check%11);
	if($check==10) $check='x';
	if($check==11) $check=0;
	return $isbn.$check;
}

function isbn10addline($isbn10)
{
	if(strlen($isbn10)==10)
	{
		$isbn=$isbn10[0].'-'.$isbn10[1].$isbn10[2].$isbn10[3].$isbn10[4].$isbn10[5].'-'.$isbn10[6].$isbn10[7].$isbn10[8].'-'.$isbn10[9];
		return $isbn;
	}
	else
	return $isbn10;
}

function isbn13addline($isbn13)
{
	if(strlen($isbn13)==13)
	{
		$isbn=$isbn13[0].$isbn13[1].$isbn13[2].'-'.$isbn13[3].'-'.$isbn13[4].$isbn13[5].$isbn13[6].$isbn13[7].$isbn13[8].'-'.$isbn13[9].$isbn13[10].$isbn13[11].'-'.$isbn13[12];
		return $isbn;
	}
	else
	return $isbn13;
}

function getbinaryfrompicture($bild)
{
	if($handle = fopen(htmlspecialchars($bild), "r"))
	{
		while(!feof($handle)) 
		$buffer.=fgets($handle, 4096);
		fclose ($handle);
		return base64_encode($buffer);
	}
	else
	return FALSE;
}
?>
