#import ez_setup # From http://peak.telecommunity.com/DevCenter/setuptools
#ez_setup.use_setuptools()

from setuptools import setup, find_packages

_dependencies = """
egenix-mxdatetime >= 2.0.6
mysqldb >= 1.2.1c3
dnspython >= 1.3.4
"""

setup(
    name = "kundebunt",
    version = "0.1a1",
    #url = 'http://www.djangoproject.com/',
    author = 'noris network AG, Michael Radziej',
    author_email = 'mir@noris.de',
    description = 'A collection of web interfaces to the kunde db at noris network AG.',
    license = 'Proprietary--No Redistribution',
    install_requires = _dependencies,
    packages = find_packages(exclude=["debugutils"]),
    #package_dir = {'kundebunt':'kundebunt'},
    package_data = {
        '': ['templates/*.html', 'templates/*.txt'],
        'kundebunt': ['_test_setup/*.py', 'locale/*/LC_MESSAGES/*.mo', 'tests/*/*.py', 'tests/fixtures/*.json'],
    },
    data_files = [('/etc/kundebunt', ['config/logging.conf', 'config/settings.ini']),
                  ('/usr/share/kundebunt/css',
                    ['static/css/kundebunt.css', 'static/css/kundebunt-ie6.css',
                     'static/css/kundebunt-ie7.css', 'static/css/kundebunt-qsu.css',
                     'static/css/kundebunt-dev.css', 'static/css/kundebunt-ext.css',
                     'static/css/the_man_cut.png']),
                  ('/usr/share/kundebunt/icons',
                    ['static/icons/arrow_switch.png', 'static/icons/box.png',
                     'static/icons/icon_alert.png', 'static/icons/icon_error.png',
                     'static/icons/icon_success.gif']),
                  ('/usr/share/kundebunt/js/hardware',
                    ['kundebunt/hardware/templates/hw_edit.js', 'kundebunt/hardware/templates/hw_lang_de.js',
                     'kundebunt/hardware/templates/hw_lang_en.js']),
                ('/usr/share/kundebunt/js/stats/server',
                    ['kundebunt/serverstats/templates/navigate.js']),
                  ('/usr/share/kundebunt/download',
                    ['static/download/footer.shtml', 'static/download/header.shtml']),
                  ('/usr/share/doc/python2.4-kundebunt',
                        ['config/example-kundebunt-fcgi.default',
                         'config/example-logging.conf',
                         'config/example-settings.ini',
                         'config/example-apache-setup',
                         'config/example-grants.sql',
                         'config/create-releasenotes-tables.sql']),
                 ],
    zip_safe = False,
)
